import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DynamodbGlobalTableConfig extends TerraformMetaArguments {
    readonly name: string;
    /** replica block */
    readonly replica: DynamodbGlobalTableReplica[];
    /** timeouts block */
    readonly timeouts?: DynamodbGlobalTableTimeouts;
}
export interface DynamodbGlobalTableReplica {
    readonly regionName: string;
}
export interface DynamodbGlobalTableTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DynamodbGlobalTable extends TerraformResource {
    constructor(scope: Construct, id: string, config: DynamodbGlobalTableConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _replica;
    get replica(): DynamodbGlobalTableReplica[];
    set replica(value: DynamodbGlobalTableReplica[]);
    private _timeouts?;
    get timeouts(): DynamodbGlobalTableTimeouts | undefined;
    set timeouts(value: DynamodbGlobalTableTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
