import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DynamodbTableItemConfig extends TerraformMetaArguments {
    readonly hashKey: string;
    readonly item: string;
    readonly rangeKey?: string;
    readonly tableName: string;
}
export declare class DynamodbTableItem extends TerraformResource {
    constructor(scope: Construct, id: string, config: DynamodbTableItemConfig);
    private _hashKey;
    get hashKey(): string;
    set hashKey(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _item;
    get item(): string;
    set item(value: string);
    private _rangeKey?;
    get rangeKey(): string | undefined;
    set rangeKey(value: string | undefined);
    private _tableName;
    get tableName(): string;
    set tableName(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
