import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DynamodbTableConfig extends TerraformMetaArguments {
    readonly billingMode?: string;
    readonly hashKey: string;
    readonly name: string;
    readonly rangeKey?: string;
    readonly readCapacity?: number;
    readonly streamEnabled?: boolean;
    readonly streamViewType?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly writeCapacity?: number;
    /** attribute block */
    readonly attribute: DynamodbTableAttribute[];
    /** global_secondary_index block */
    readonly globalSecondaryIndex?: DynamodbTableGlobalSecondaryIndex[];
    /** local_secondary_index block */
    readonly localSecondaryIndex?: DynamodbTableLocalSecondaryIndex[];
    /** point_in_time_recovery block */
    readonly pointInTimeRecovery?: DynamodbTablePointInTimeRecovery[];
    /** replica block */
    readonly replica?: DynamodbTableReplica[];
    /** server_side_encryption block */
    readonly serverSideEncryption?: DynamodbTableServerSideEncryption[];
    /** timeouts block */
    readonly timeouts?: DynamodbTableTimeouts;
    /** ttl block */
    readonly ttl?: DynamodbTableTtl[];
}
export interface DynamodbTableAttribute {
    readonly name: string;
    readonly type: string;
}
export interface DynamodbTableGlobalSecondaryIndex {
    readonly hashKey: string;
    readonly name: string;
    readonly nonKeyAttributes?: string[];
    readonly projectionType: string;
    readonly rangeKey?: string;
    readonly readCapacity?: number;
    readonly writeCapacity?: number;
}
export interface DynamodbTableLocalSecondaryIndex {
    readonly name: string;
    readonly nonKeyAttributes?: string[];
    readonly projectionType: string;
    readonly rangeKey: string;
}
export interface DynamodbTablePointInTimeRecovery {
    readonly enabled: boolean;
}
export interface DynamodbTableReplica {
    readonly regionName: string;
}
export interface DynamodbTableServerSideEncryption {
    readonly enabled: boolean;
    readonly kmsKeyArn?: string;
}
export interface DynamodbTableTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export interface DynamodbTableTtl {
    readonly attributeName: string;
    readonly enabled?: boolean;
}
export declare class DynamodbTable extends TerraformResource {
    constructor(scope: Construct, id: string, config: DynamodbTableConfig);
    get arn(): string;
    private _billingMode?;
    get billingMode(): string | undefined;
    set billingMode(value: string | undefined);
    private _hashKey;
    get hashKey(): string;
    set hashKey(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _rangeKey?;
    get rangeKey(): string | undefined;
    set rangeKey(value: string | undefined);
    private _readCapacity?;
    get readCapacity(): number | undefined;
    set readCapacity(value: number | undefined);
    get streamArn(): string;
    private _streamEnabled?;
    get streamEnabled(): boolean | undefined;
    set streamEnabled(value: boolean | undefined);
    get streamLabel(): string;
    private _streamViewType?;
    get streamViewType(): string | undefined;
    set streamViewType(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _writeCapacity?;
    get writeCapacity(): number | undefined;
    set writeCapacity(value: number | undefined);
    private _attribute;
    get attribute(): DynamodbTableAttribute[];
    set attribute(value: DynamodbTableAttribute[]);
    private _globalSecondaryIndex?;
    get globalSecondaryIndex(): DynamodbTableGlobalSecondaryIndex[] | undefined;
    set globalSecondaryIndex(value: DynamodbTableGlobalSecondaryIndex[] | undefined);
    private _localSecondaryIndex?;
    get localSecondaryIndex(): DynamodbTableLocalSecondaryIndex[] | undefined;
    set localSecondaryIndex(value: DynamodbTableLocalSecondaryIndex[] | undefined);
    private _pointInTimeRecovery?;
    get pointInTimeRecovery(): DynamodbTablePointInTimeRecovery[] | undefined;
    set pointInTimeRecovery(value: DynamodbTablePointInTimeRecovery[] | undefined);
    private _replica?;
    get replica(): DynamodbTableReplica[] | undefined;
    set replica(value: DynamodbTableReplica[] | undefined);
    private _serverSideEncryption?;
    get serverSideEncryption(): DynamodbTableServerSideEncryption[] | undefined;
    set serverSideEncryption(value: DynamodbTableServerSideEncryption[] | undefined);
    private _timeouts?;
    get timeouts(): DynamodbTableTimeouts | undefined;
    set timeouts(value: DynamodbTableTimeouts | undefined);
    private _ttl?;
    get ttl(): DynamodbTableTtl[] | undefined;
    set ttl(value: DynamodbTableTtl[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
