import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EbsSnapshotCopyConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly encrypted?: boolean;
    readonly kmsKeyId?: string;
    readonly sourceRegion: string;
    readonly sourceSnapshotId: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class EbsSnapshotCopy extends TerraformResource {
    constructor(scope: Construct, id: string, config: EbsSnapshotCopyConfig);
    get arn(): string;
    get dataEncryptionKeyId(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _encrypted?;
    get encrypted(): boolean | undefined;
    set encrypted(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    get ownerAlias(): string;
    get ownerId(): string;
    private _sourceRegion;
    get sourceRegion(): string;
    set sourceRegion(value: string);
    private _sourceSnapshotId;
    get sourceSnapshotId(): string;
    set sourceSnapshotId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get volumeId(): string;
    get volumeSize(): number;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
