import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EbsSnapshotConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly volumeId: string;
    /** timeouts block */
    readonly timeouts?: EbsSnapshotTimeouts;
}
export interface EbsSnapshotTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class EbsSnapshot extends TerraformResource {
    constructor(scope: Construct, id: string, config: EbsSnapshotConfig);
    get arn(): string;
    get dataEncryptionKeyId(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get encrypted(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    get ownerAlias(): string;
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _volumeId;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeSize(): number;
    private _timeouts?;
    get timeouts(): EbsSnapshotTimeouts | undefined;
    set timeouts(value: EbsSnapshotTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
