import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EbsVolumeConfig extends TerraformMetaArguments {
    readonly availabilityZone: string;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly multiAttachEnabled?: boolean;
    readonly outpostArn?: string;
    readonly size?: number;
    readonly snapshotId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly type?: string;
}
export declare class EbsVolume extends TerraformResource {
    constructor(scope: Construct, id: string, config: EbsVolumeConfig);
    get arn(): string;
    private _availabilityZone;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    private _encrypted?;
    get encrypted(): boolean | undefined;
    set encrypted(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _iops?;
    get iops(): number | undefined;
    set iops(value: number | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _multiAttachEnabled?;
    get multiAttachEnabled(): boolean | undefined;
    set multiAttachEnabled(value: boolean | undefined);
    private _outpostArn?;
    get outpostArn(): string | undefined;
    set outpostArn(value: string | undefined);
    private _size?;
    get size(): number | undefined;
    set size(value: number | undefined);
    private _snapshotId?;
    get snapshotId(): string | undefined;
    set snapshotId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
