import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2CapacityReservationConfig extends TerraformMetaArguments {
    readonly availabilityZone: string;
    readonly ebsOptimized?: boolean;
    readonly endDate?: string;
    readonly endDateType?: string;
    readonly ephemeralStorage?: boolean;
    readonly instanceCount: number;
    readonly instanceMatchCriteria?: string;
    readonly instancePlatform: string;
    readonly instanceType: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly tenancy?: string;
}
export declare class Ec2CapacityReservation extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2CapacityReservationConfig);
    get arn(): string;
    private _availabilityZone;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    private _ebsOptimized?;
    get ebsOptimized(): boolean | undefined;
    set ebsOptimized(value: boolean | undefined);
    private _endDate?;
    get endDate(): string | undefined;
    set endDate(value: string | undefined);
    private _endDateType?;
    get endDateType(): string | undefined;
    set endDateType(value: string | undefined);
    private _ephemeralStorage?;
    get ephemeralStorage(): boolean | undefined;
    set ephemeralStorage(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceCount;
    get instanceCount(): number;
    set instanceCount(value: number);
    private _instanceMatchCriteria?;
    get instanceMatchCriteria(): string | undefined;
    set instanceMatchCriteria(value: string | undefined);
    private _instancePlatform;
    get instancePlatform(): string;
    set instancePlatform(value: string);
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _tenancy?;
    get tenancy(): string | undefined;
    set tenancy(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
