import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2ClientVpnEndpointConfig extends TerraformMetaArguments {
    readonly clientCidrBlock: string;
    readonly description?: string;
    readonly dnsServers?: string[];
    readonly serverCertificateArn: string;
    readonly splitTunnel?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly transportProtocol?: string;
    /** authentication_options block */
    readonly authenticationOptions: Ec2ClientVpnEndpointAuthenticationOptions[];
    /** connection_log_options block */
    readonly connectionLogOptions: Ec2ClientVpnEndpointConnectionLogOptions[];
}
export interface Ec2ClientVpnEndpointAuthenticationOptions {
    readonly activeDirectoryId?: string;
    readonly rootCertificateChainArn?: string;
    readonly type: string;
}
export interface Ec2ClientVpnEndpointConnectionLogOptions {
    readonly cloudwatchLogGroup?: string;
    readonly cloudwatchLogStream?: string;
    readonly enabled: boolean;
}
export declare class Ec2ClientVpnEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2ClientVpnEndpointConfig);
    get arn(): string;
    private _clientCidrBlock;
    get clientCidrBlock(): string;
    set clientCidrBlock(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get dnsName(): string;
    private _dnsServers?;
    get dnsServers(): string[] | undefined;
    set dnsServers(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _serverCertificateArn;
    get serverCertificateArn(): string;
    set serverCertificateArn(value: string);
    private _splitTunnel?;
    get splitTunnel(): boolean | undefined;
    set splitTunnel(value: boolean | undefined);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _transportProtocol?;
    get transportProtocol(): string | undefined;
    set transportProtocol(value: string | undefined);
    private _authenticationOptions;
    get authenticationOptions(): Ec2ClientVpnEndpointAuthenticationOptions[];
    set authenticationOptions(value: Ec2ClientVpnEndpointAuthenticationOptions[]);
    private _connectionLogOptions;
    get connectionLogOptions(): Ec2ClientVpnEndpointConnectionLogOptions[];
    set connectionLogOptions(value: Ec2ClientVpnEndpointConnectionLogOptions[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
