import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2FleetConfig extends TerraformMetaArguments {
    readonly excessCapacityTerminationPolicy?: string;
    readonly replaceUnhealthyInstances?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly terminateInstances?: boolean;
    readonly terminateInstancesWithExpiration?: boolean;
    readonly type?: string;
    /** launch_template_config block */
    readonly launchTemplateConfig: Ec2FleetLaunchTemplateConfig[];
    /** on_demand_options block */
    readonly onDemandOptions?: Ec2FleetOnDemandOptions[];
    /** spot_options block */
    readonly spotOptions?: Ec2FleetSpotOptions[];
    /** target_capacity_specification block */
    readonly targetCapacitySpecification: Ec2FleetTargetCapacitySpecification[];
    /** timeouts block */
    readonly timeouts?: Ec2FleetTimeouts;
}
export interface Ec2FleetLaunchTemplateConfigLaunchTemplateSpecification {
    readonly launchTemplateId?: string;
    readonly launchTemplateName?: string;
    readonly version: string;
}
export interface Ec2FleetLaunchTemplateConfigOverride {
    readonly availabilityZone?: string;
    readonly instanceType?: string;
    readonly maxPrice?: string;
    readonly priority?: number;
    readonly subnetId?: string;
    readonly weightedCapacity?: number;
}
export interface Ec2FleetLaunchTemplateConfig {
    /** launch_template_specification block */
    readonly launchTemplateSpecification: Ec2FleetLaunchTemplateConfigLaunchTemplateSpecification[];
    /** override block */
    readonly override?: Ec2FleetLaunchTemplateConfigOverride[];
}
export interface Ec2FleetOnDemandOptions {
    readonly allocationStrategy?: string;
}
export interface Ec2FleetSpotOptions {
    readonly allocationStrategy?: string;
    readonly instanceInterruptionBehavior?: string;
    readonly instancePoolsToUseCount?: number;
}
export interface Ec2FleetTargetCapacitySpecification {
    readonly defaultTargetCapacityType: string;
    readonly onDemandTargetCapacity?: number;
    readonly spotTargetCapacity?: number;
    readonly totalTargetCapacity: number;
}
export interface Ec2FleetTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Ec2Fleet extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2FleetConfig);
    private _excessCapacityTerminationPolicy?;
    get excessCapacityTerminationPolicy(): string | undefined;
    set excessCapacityTerminationPolicy(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _replaceUnhealthyInstances?;
    get replaceUnhealthyInstances(): boolean | undefined;
    set replaceUnhealthyInstances(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _terminateInstances?;
    get terminateInstances(): boolean | undefined;
    set terminateInstances(value: boolean | undefined);
    private _terminateInstancesWithExpiration?;
    get terminateInstancesWithExpiration(): boolean | undefined;
    set terminateInstancesWithExpiration(value: boolean | undefined);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    private _launchTemplateConfig;
    get launchTemplateConfig(): Ec2FleetLaunchTemplateConfig[];
    set launchTemplateConfig(value: Ec2FleetLaunchTemplateConfig[]);
    private _onDemandOptions?;
    get onDemandOptions(): Ec2FleetOnDemandOptions[] | undefined;
    set onDemandOptions(value: Ec2FleetOnDemandOptions[] | undefined);
    private _spotOptions?;
    get spotOptions(): Ec2FleetSpotOptions[] | undefined;
    set spotOptions(value: Ec2FleetSpotOptions[] | undefined);
    private _targetCapacitySpecification;
    get targetCapacitySpecification(): Ec2FleetTargetCapacitySpecification[];
    set targetCapacitySpecification(value: Ec2FleetTargetCapacitySpecification[]);
    private _timeouts?;
    get timeouts(): Ec2FleetTimeouts | undefined;
    set timeouts(value: Ec2FleetTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
