"use strict";
// https://www.terraform.io/docs/providers/aws/r/ec2_local_gateway_route.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2LocalGatewayRoute = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Ec2LocalGatewayRoute extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ec2_local_gateway_route',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._destinationCidrBlock = config.destinationCidrBlock;
        this._localGatewayRouteTableId = config.localGatewayRouteTableId;
        this._localGatewayVirtualInterfaceGroupId = config.localGatewayVirtualInterfaceGroupId;
    }
    get destinationCidrBlock() {
        return this._destinationCidrBlock;
    }
    set destinationCidrBlock(value) {
        this._destinationCidrBlock = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get localGatewayRouteTableId() {
        return this._localGatewayRouteTableId;
    }
    set localGatewayRouteTableId(value) {
        this._localGatewayRouteTableId = value;
    }
    get localGatewayVirtualInterfaceGroupId() {
        return this._localGatewayVirtualInterfaceGroupId;
    }
    set localGatewayVirtualInterfaceGroupId(value) {
        this._localGatewayVirtualInterfaceGroupId = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            destination_cidr_block: this._destinationCidrBlock,
            local_gateway_route_table_id: this._localGatewayRouteTableId,
            local_gateway_virtual_interface_group_id: this._localGatewayVirtualInterfaceGroupId,
        };
    }
}
exports.Ec2LocalGatewayRoute = Ec2LocalGatewayRoute;
//# sourceMappingURL=data:application/json;base64,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