import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2TrafficMirrorFilterRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly destinationCidrBlock: string;
    readonly protocol?: number;
    readonly ruleAction: string;
    readonly ruleNumber: number;
    readonly sourceCidrBlock: string;
    readonly trafficDirection: string;
    readonly trafficMirrorFilterId: string;
    /** destination_port_range block */
    readonly destinationPortRange?: Ec2TrafficMirrorFilterRuleDestinationPortRange[];
    /** source_port_range block */
    readonly sourcePortRange?: Ec2TrafficMirrorFilterRuleSourcePortRange[];
}
export interface Ec2TrafficMirrorFilterRuleDestinationPortRange {
    readonly fromPort?: number;
    readonly toPort?: number;
}
export interface Ec2TrafficMirrorFilterRuleSourcePortRange {
    readonly fromPort?: number;
    readonly toPort?: number;
}
export declare class Ec2TrafficMirrorFilterRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2TrafficMirrorFilterRuleConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _destinationCidrBlock;
    get destinationCidrBlock(): string;
    set destinationCidrBlock(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _protocol?;
    get protocol(): number | undefined;
    set protocol(value: number | undefined);
    private _ruleAction;
    get ruleAction(): string;
    set ruleAction(value: string);
    private _ruleNumber;
    get ruleNumber(): number;
    set ruleNumber(value: number);
    private _sourceCidrBlock;
    get sourceCidrBlock(): string;
    set sourceCidrBlock(value: string);
    private _trafficDirection;
    get trafficDirection(): string;
    set trafficDirection(value: string);
    private _trafficMirrorFilterId;
    get trafficMirrorFilterId(): string;
    set trafficMirrorFilterId(value: string);
    private _destinationPortRange?;
    get destinationPortRange(): Ec2TrafficMirrorFilterRuleDestinationPortRange[] | undefined;
    set destinationPortRange(value: Ec2TrafficMirrorFilterRuleDestinationPortRange[] | undefined);
    private _sourcePortRange?;
    get sourcePortRange(): Ec2TrafficMirrorFilterRuleSourcePortRange[] | undefined;
    set sourcePortRange(value: Ec2TrafficMirrorFilterRuleSourcePortRange[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
