"use strict";
// https://www.terraform.io/docs/providers/aws/r/ec2_traffic_mirror_filter_rule.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TrafficMirrorFilterRule = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Ec2TrafficMirrorFilterRule extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ec2_traffic_mirror_filter_rule',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._description = config.description;
        this._destinationCidrBlock = config.destinationCidrBlock;
        this._protocol = config.protocol;
        this._ruleAction = config.ruleAction;
        this._ruleNumber = config.ruleNumber;
        this._sourceCidrBlock = config.sourceCidrBlock;
        this._trafficDirection = config.trafficDirection;
        this._trafficMirrorFilterId = config.trafficMirrorFilterId;
        this._destinationPortRange = config.destinationPortRange;
        this._sourcePortRange = config.sourcePortRange;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get destinationCidrBlock() {
        return this._destinationCidrBlock;
    }
    set destinationCidrBlock(value) {
        this._destinationCidrBlock = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get protocol() {
        return this._protocol;
    }
    set protocol(value) {
        this._protocol = value;
    }
    get ruleAction() {
        return this._ruleAction;
    }
    set ruleAction(value) {
        this._ruleAction = value;
    }
    get ruleNumber() {
        return this._ruleNumber;
    }
    set ruleNumber(value) {
        this._ruleNumber = value;
    }
    get sourceCidrBlock() {
        return this._sourceCidrBlock;
    }
    set sourceCidrBlock(value) {
        this._sourceCidrBlock = value;
    }
    get trafficDirection() {
        return this._trafficDirection;
    }
    set trafficDirection(value) {
        this._trafficDirection = value;
    }
    get trafficMirrorFilterId() {
        return this._trafficMirrorFilterId;
    }
    set trafficMirrorFilterId(value) {
        this._trafficMirrorFilterId = value;
    }
    get destinationPortRange() {
        return this._destinationPortRange;
    }
    set destinationPortRange(value) {
        this._destinationPortRange = value;
    }
    get sourcePortRange() {
        return this._sourcePortRange;
    }
    set sourcePortRange(value) {
        this._sourcePortRange = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: this._description,
            destination_cidr_block: this._destinationCidrBlock,
            protocol: this._protocol,
            rule_action: this._ruleAction,
            rule_number: this._ruleNumber,
            source_cidr_block: this._sourceCidrBlock,
            traffic_direction: this._trafficDirection,
            traffic_mirror_filter_id: this._trafficMirrorFilterId,
            destination_port_range: this._destinationPortRange,
            source_port_range: this._sourcePortRange,
        };
    }
}
exports.Ec2TrafficMirrorFilterRule = Ec2TrafficMirrorFilterRule;
//# sourceMappingURL=data:application/json;base64,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