import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2TrafficMirrorSessionConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly networkInterfaceId: string;
    readonly packetLength?: number;
    readonly sessionNumber: number;
    readonly tags?: {
        [key: string]: string;
    };
    readonly trafficMirrorFilterId: string;
    readonly trafficMirrorTargetId: string;
    readonly virtualNetworkId?: number;
}
export declare class Ec2TrafficMirrorSession extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2TrafficMirrorSessionConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _networkInterfaceId;
    get networkInterfaceId(): string;
    set networkInterfaceId(value: string);
    private _packetLength?;
    get packetLength(): number | undefined;
    set packetLength(value: number | undefined);
    private _sessionNumber;
    get sessionNumber(): number;
    set sessionNumber(value: number);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _trafficMirrorFilterId;
    get trafficMirrorFilterId(): string;
    set trafficMirrorFilterId(value: string);
    private _trafficMirrorTargetId;
    get trafficMirrorTargetId(): string;
    set trafficMirrorTargetId(value: string);
    private _virtualNetworkId?;
    get virtualNetworkId(): number | undefined;
    set virtualNetworkId(value: number | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
