import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2TrafficMirrorTargetConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly networkInterfaceId?: string;
    readonly networkLoadBalancerArn?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class Ec2TrafficMirrorTarget extends TerraformResource {
    constructor(scope: Construct, id: string, config?: Ec2TrafficMirrorTargetConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _networkInterfaceId?;
    get networkInterfaceId(): string | undefined;
    set networkInterfaceId(value: string | undefined);
    private _networkLoadBalancerArn?;
    get networkLoadBalancerArn(): string | undefined;
    set networkLoadBalancerArn(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
