import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2TransitGatewayVpcAttachmentConfig extends TerraformMetaArguments {
    readonly dnsSupport?: string;
    readonly ipv6Support?: string;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly transitGatewayDefaultRouteTableAssociation?: boolean;
    readonly transitGatewayDefaultRouteTablePropagation?: boolean;
    readonly transitGatewayId: string;
    readonly vpcId: string;
}
export declare class Ec2TransitGatewayVpcAttachment extends TerraformResource {
    constructor(scope: Construct, id: string, config: Ec2TransitGatewayVpcAttachmentConfig);
    private _dnsSupport?;
    get dnsSupport(): string | undefined;
    set dnsSupport(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipv6Support?;
    get ipv6Support(): string | undefined;
    set ipv6Support(value: string | undefined);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _transitGatewayDefaultRouteTableAssociation?;
    get transitGatewayDefaultRouteTableAssociation(): boolean | undefined;
    set transitGatewayDefaultRouteTableAssociation(value: boolean | undefined);
    private _transitGatewayDefaultRouteTablePropagation?;
    get transitGatewayDefaultRouteTablePropagation(): boolean | undefined;
    set transitGatewayDefaultRouteTablePropagation(value: boolean | undefined);
    private _transitGatewayId;
    get transitGatewayId(): string;
    set transitGatewayId(value: string);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcOwnerId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
