"use strict";
// https://www.terraform.io/docs/providers/aws/r/ec2_transit_gateway_vpc_attachment.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TransitGatewayVpcAttachment = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Ec2TransitGatewayVpcAttachment extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ec2_transit_gateway_vpc_attachment',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._dnsSupport = config.dnsSupport;
        this._ipv6Support = config.ipv6Support;
        this._subnetIds = config.subnetIds;
        this._tags = config.tags;
        this._transitGatewayDefaultRouteTableAssociation = config.transitGatewayDefaultRouteTableAssociation;
        this._transitGatewayDefaultRouteTablePropagation = config.transitGatewayDefaultRouteTablePropagation;
        this._transitGatewayId = config.transitGatewayId;
        this._vpcId = config.vpcId;
    }
    get dnsSupport() {
        return this._dnsSupport;
    }
    set dnsSupport(value) {
        this._dnsSupport = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get ipv6Support() {
        return this._ipv6Support;
    }
    set ipv6Support(value) {
        this._ipv6Support = value;
    }
    get subnetIds() {
        return this._subnetIds;
    }
    set subnetIds(value) {
        this._subnetIds = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get transitGatewayDefaultRouteTableAssociation() {
        return this._transitGatewayDefaultRouteTableAssociation;
    }
    set transitGatewayDefaultRouteTableAssociation(value) {
        this._transitGatewayDefaultRouteTableAssociation = value;
    }
    get transitGatewayDefaultRouteTablePropagation() {
        return this._transitGatewayDefaultRouteTablePropagation;
    }
    set transitGatewayDefaultRouteTablePropagation(value) {
        this._transitGatewayDefaultRouteTablePropagation = value;
    }
    get transitGatewayId() {
        return this._transitGatewayId;
    }
    set transitGatewayId(value) {
        this._transitGatewayId = value;
    }
    get vpcId() {
        return this._vpcId;
    }
    set vpcId(value) {
        this._vpcId = value;
    }
    // vpc_owner_id - computed: true, optional: false, required: true
    get vpcOwnerId() {
        return this.getStringAttribute('vpc_owner_id');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dns_support: this._dnsSupport,
            ipv6_support: this._ipv6Support,
            subnet_ids: this._subnetIds,
            tags: this._tags,
            transit_gateway_default_route_table_association: this._transitGatewayDefaultRouteTableAssociation,
            transit_gateway_default_route_table_propagation: this._transitGatewayDefaultRouteTablePropagation,
            transit_gateway_id: this._transitGatewayId,
            vpc_id: this._vpcId,
        };
    }
}
exports.Ec2TransitGatewayVpcAttachment = Ec2TransitGatewayVpcAttachment;
//# sourceMappingURL=data:application/json;base64,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