import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Ec2TransitGatewayConfig extends TerraformMetaArguments {
    readonly amazonSideAsn?: number;
    readonly autoAcceptSharedAttachments?: string;
    readonly defaultRouteTableAssociation?: string;
    readonly defaultRouteTablePropagation?: string;
    readonly description?: string;
    readonly dnsSupport?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpnEcmpSupport?: string;
}
export declare class Ec2TransitGateway extends TerraformResource {
    constructor(scope: Construct, id: string, config?: Ec2TransitGatewayConfig);
    private _amazonSideAsn?;
    get amazonSideAsn(): number | undefined;
    set amazonSideAsn(value: number | undefined);
    get arn(): string;
    get associationDefaultRouteTableId(): string;
    private _autoAcceptSharedAttachments?;
    get autoAcceptSharedAttachments(): string | undefined;
    set autoAcceptSharedAttachments(value: string | undefined);
    private _defaultRouteTableAssociation?;
    get defaultRouteTableAssociation(): string | undefined;
    set defaultRouteTableAssociation(value: string | undefined);
    private _defaultRouteTablePropagation?;
    get defaultRouteTablePropagation(): string | undefined;
    set defaultRouteTablePropagation(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _dnsSupport?;
    get dnsSupport(): string | undefined;
    set dnsSupport(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    get propagationDefaultRouteTableId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpnEcmpSupport?;
    get vpnEcmpSupport(): string | undefined;
    set vpnEcmpSupport(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
