import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EcrRepositoryConfig extends TerraformMetaArguments {
    readonly imageTagMutability?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** image_scanning_configuration block */
    readonly imageScanningConfiguration?: EcrRepositoryImageScanningConfiguration[];
    /** timeouts block */
    readonly timeouts?: EcrRepositoryTimeouts;
}
export interface EcrRepositoryImageScanningConfiguration {
    readonly scanOnPush: boolean;
}
export interface EcrRepositoryTimeouts {
    readonly delete?: string;
}
export declare class EcrRepository extends TerraformResource {
    constructor(scope: Construct, id: string, config: EcrRepositoryConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _imageTagMutability?;
    get imageTagMutability(): string | undefined;
    set imageTagMutability(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get registryId(): string;
    get repositoryUrl(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _imageScanningConfiguration?;
    get imageScanningConfiguration(): EcrRepositoryImageScanningConfiguration[] | undefined;
    set imageScanningConfiguration(value: EcrRepositoryImageScanningConfiguration[] | undefined);
    private _timeouts?;
    get timeouts(): EcrRepositoryTimeouts | undefined;
    set timeouts(value: EcrRepositoryTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
