import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EcsCapacityProviderConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** auto_scaling_group_provider block */
    readonly autoScalingGroupProvider: EcsCapacityProviderAutoScalingGroupProvider[];
}
export interface EcsCapacityProviderAutoScalingGroupProviderManagedScaling {
    readonly maximumScalingStepSize?: number;
    readonly minimumScalingStepSize?: number;
    readonly status?: string;
    readonly targetCapacity?: number;
}
export interface EcsCapacityProviderAutoScalingGroupProvider {
    readonly autoScalingGroupArn: string;
    readonly managedTerminationProtection?: string;
    /** managed_scaling block */
    readonly managedScaling?: EcsCapacityProviderAutoScalingGroupProviderManagedScaling[];
}
export declare class EcsCapacityProvider extends TerraformResource {
    constructor(scope: Construct, id: string, config: EcsCapacityProviderConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _autoScalingGroupProvider;
    get autoScalingGroupProvider(): EcsCapacityProviderAutoScalingGroupProvider[];
    set autoScalingGroupProvider(value: EcsCapacityProviderAutoScalingGroupProvider[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
