import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EcsClusterConfig extends TerraformMetaArguments {
    readonly capacityProviders?: string[];
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** default_capacity_provider_strategy block */
    readonly defaultCapacityProviderStrategy?: EcsClusterDefaultCapacityProviderStrategy[];
    /** setting block */
    readonly setting?: EcsClusterSetting[];
}
export interface EcsClusterDefaultCapacityProviderStrategy {
    readonly base?: number;
    readonly capacityProvider: string;
    readonly weight?: number;
}
export interface EcsClusterSetting {
    readonly name: string;
    readonly value: string;
}
export declare class EcsCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: EcsClusterConfig);
    get arn(): string;
    private _capacityProviders?;
    get capacityProviders(): string[] | undefined;
    set capacityProviders(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _defaultCapacityProviderStrategy?;
    get defaultCapacityProviderStrategy(): EcsClusterDefaultCapacityProviderStrategy[] | undefined;
    set defaultCapacityProviderStrategy(value: EcsClusterDefaultCapacityProviderStrategy[] | undefined);
    private _setting?;
    get setting(): EcsClusterSetting[] | undefined;
    set setting(value: EcsClusterSetting[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
