import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EcsServiceConfig extends TerraformMetaArguments {
    readonly cluster?: string;
    readonly deploymentMaximumPercent?: number;
    readonly deploymentMinimumHealthyPercent?: number;
    readonly desiredCount?: number;
    readonly enableEcsManagedTags?: boolean;
    readonly forceNewDeployment?: boolean;
    readonly healthCheckGracePeriodSeconds?: number;
    readonly iamRole?: string;
    readonly launchType?: string;
    readonly name: string;
    readonly platformVersion?: string;
    readonly propagateTags?: string;
    readonly schedulingStrategy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly taskDefinition?: string;
    /** capacity_provider_strategy block */
    readonly capacityProviderStrategy?: EcsServiceCapacityProviderStrategy[];
    /** deployment_controller block */
    readonly deploymentController?: EcsServiceDeploymentController[];
    /** load_balancer block */
    readonly loadBalancer?: EcsServiceLoadBalancer[];
    /** network_configuration block */
    readonly networkConfiguration?: EcsServiceNetworkConfiguration[];
    /** ordered_placement_strategy block */
    readonly orderedPlacementStrategy?: EcsServiceOrderedPlacementStrategy[];
    /** placement_constraints block */
    readonly placementConstraints?: EcsServicePlacementConstraints[];
    /** placement_strategy block */
    readonly placementStrategy?: EcsServicePlacementStrategy[];
    /** service_registries block */
    readonly serviceRegistries?: EcsServiceServiceRegistries[];
    /** timeouts block */
    readonly timeouts?: EcsServiceTimeouts;
}
export interface EcsServiceCapacityProviderStrategy {
    readonly base?: number;
    readonly capacityProvider: string;
    readonly weight?: number;
}
export interface EcsServiceDeploymentController {
    readonly type?: string;
}
export interface EcsServiceLoadBalancer {
    readonly containerName: string;
    readonly containerPort: number;
    readonly elbName?: string;
    readonly targetGroupArn?: string;
}
export interface EcsServiceNetworkConfiguration {
    readonly assignPublicIp?: boolean;
    readonly securityGroups?: string[];
    readonly subnets: string[];
}
export interface EcsServiceOrderedPlacementStrategy {
    readonly field?: string;
    readonly type: string;
}
export interface EcsServicePlacementConstraints {
    readonly expression?: string;
    readonly type: string;
}
export interface EcsServicePlacementStrategy {
    readonly field?: string;
    readonly type: string;
}
export interface EcsServiceServiceRegistries {
    readonly containerName?: string;
    readonly containerPort?: number;
    readonly port?: number;
    readonly registryArn: string;
}
export interface EcsServiceTimeouts {
    readonly delete?: string;
}
export declare class EcsService extends TerraformResource {
    constructor(scope: Construct, id: string, config: EcsServiceConfig);
    private _cluster?;
    get cluster(): string | undefined;
    set cluster(value: string | undefined);
    private _deploymentMaximumPercent?;
    get deploymentMaximumPercent(): number | undefined;
    set deploymentMaximumPercent(value: number | undefined);
    private _deploymentMinimumHealthyPercent?;
    get deploymentMinimumHealthyPercent(): number | undefined;
    set deploymentMinimumHealthyPercent(value: number | undefined);
    private _desiredCount?;
    get desiredCount(): number | undefined;
    set desiredCount(value: number | undefined);
    private _enableEcsManagedTags?;
    get enableEcsManagedTags(): boolean | undefined;
    set enableEcsManagedTags(value: boolean | undefined);
    private _forceNewDeployment?;
    get forceNewDeployment(): boolean | undefined;
    set forceNewDeployment(value: boolean | undefined);
    private _healthCheckGracePeriodSeconds?;
    get healthCheckGracePeriodSeconds(): number | undefined;
    set healthCheckGracePeriodSeconds(value: number | undefined);
    private _iamRole?;
    get iamRole(): string | undefined;
    set iamRole(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _launchType?;
    get launchType(): string | undefined;
    set launchType(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _platformVersion?;
    get platformVersion(): string | undefined;
    set platformVersion(value: string | undefined);
    private _propagateTags?;
    get propagateTags(): string | undefined;
    set propagateTags(value: string | undefined);
    private _schedulingStrategy?;
    get schedulingStrategy(): string | undefined;
    set schedulingStrategy(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _taskDefinition?;
    get taskDefinition(): string | undefined;
    set taskDefinition(value: string | undefined);
    private _capacityProviderStrategy?;
    get capacityProviderStrategy(): EcsServiceCapacityProviderStrategy[] | undefined;
    set capacityProviderStrategy(value: EcsServiceCapacityProviderStrategy[] | undefined);
    private _deploymentController?;
    get deploymentController(): EcsServiceDeploymentController[] | undefined;
    set deploymentController(value: EcsServiceDeploymentController[] | undefined);
    private _loadBalancer?;
    get loadBalancer(): EcsServiceLoadBalancer[] | undefined;
    set loadBalancer(value: EcsServiceLoadBalancer[] | undefined);
    private _networkConfiguration?;
    get networkConfiguration(): EcsServiceNetworkConfiguration[] | undefined;
    set networkConfiguration(value: EcsServiceNetworkConfiguration[] | undefined);
    private _orderedPlacementStrategy?;
    get orderedPlacementStrategy(): EcsServiceOrderedPlacementStrategy[] | undefined;
    set orderedPlacementStrategy(value: EcsServiceOrderedPlacementStrategy[] | undefined);
    private _placementConstraints?;
    get placementConstraints(): EcsServicePlacementConstraints[] | undefined;
    set placementConstraints(value: EcsServicePlacementConstraints[] | undefined);
    private _placementStrategy?;
    get placementStrategy(): EcsServicePlacementStrategy[] | undefined;
    set placementStrategy(value: EcsServicePlacementStrategy[] | undefined);
    private _serviceRegistries?;
    get serviceRegistries(): EcsServiceServiceRegistries[] | undefined;
    set serviceRegistries(value: EcsServiceServiceRegistries[] | undefined);
    private _timeouts?;
    get timeouts(): EcsServiceTimeouts | undefined;
    set timeouts(value: EcsServiceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
