"use strict";
// https://www.terraform.io/docs/providers/aws/r/ecs_service.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsService = void 0;
const cdktf_1 = require("cdktf");
// Resource
class EcsService extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ecs_service',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cluster = config.cluster;
        this._deploymentMaximumPercent = config.deploymentMaximumPercent;
        this._deploymentMinimumHealthyPercent = config.deploymentMinimumHealthyPercent;
        this._desiredCount = config.desiredCount;
        this._enableEcsManagedTags = config.enableEcsManagedTags;
        this._forceNewDeployment = config.forceNewDeployment;
        this._healthCheckGracePeriodSeconds = config.healthCheckGracePeriodSeconds;
        this._iamRole = config.iamRole;
        this._launchType = config.launchType;
        this._name = config.name;
        this._platformVersion = config.platformVersion;
        this._propagateTags = config.propagateTags;
        this._schedulingStrategy = config.schedulingStrategy;
        this._tags = config.tags;
        this._taskDefinition = config.taskDefinition;
        this._capacityProviderStrategy = config.capacityProviderStrategy;
        this._deploymentController = config.deploymentController;
        this._loadBalancer = config.loadBalancer;
        this._networkConfiguration = config.networkConfiguration;
        this._orderedPlacementStrategy = config.orderedPlacementStrategy;
        this._placementConstraints = config.placementConstraints;
        this._placementStrategy = config.placementStrategy;
        this._serviceRegistries = config.serviceRegistries;
        this._timeouts = config.timeouts;
    }
    get cluster() {
        var _a;
        return (_a = this._cluster) !== null && _a !== void 0 ? _a : this.getStringAttribute('cluster');
    }
    set cluster(value) {
        this._cluster = value;
    }
    get deploymentMaximumPercent() {
        return this._deploymentMaximumPercent;
    }
    set deploymentMaximumPercent(value) {
        this._deploymentMaximumPercent = value;
    }
    get deploymentMinimumHealthyPercent() {
        return this._deploymentMinimumHealthyPercent;
    }
    set deploymentMinimumHealthyPercent(value) {
        this._deploymentMinimumHealthyPercent = value;
    }
    get desiredCount() {
        return this._desiredCount;
    }
    set desiredCount(value) {
        this._desiredCount = value;
    }
    get enableEcsManagedTags() {
        return this._enableEcsManagedTags;
    }
    set enableEcsManagedTags(value) {
        this._enableEcsManagedTags = value;
    }
    get forceNewDeployment() {
        return this._forceNewDeployment;
    }
    set forceNewDeployment(value) {
        this._forceNewDeployment = value;
    }
    get healthCheckGracePeriodSeconds() {
        return this._healthCheckGracePeriodSeconds;
    }
    set healthCheckGracePeriodSeconds(value) {
        this._healthCheckGracePeriodSeconds = value;
    }
    get iamRole() {
        var _a;
        return (_a = this._iamRole) !== null && _a !== void 0 ? _a : this.getStringAttribute('iam_role');
    }
    set iamRole(value) {
        this._iamRole = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get launchType() {
        var _a;
        return (_a = this._launchType) !== null && _a !== void 0 ? _a : this.getStringAttribute('launch_type');
    }
    set launchType(value) {
        this._launchType = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get platformVersion() {
        var _a;
        return (_a = this._platformVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('platform_version');
    }
    set platformVersion(value) {
        this._platformVersion = value;
    }
    get propagateTags() {
        return this._propagateTags;
    }
    set propagateTags(value) {
        this._propagateTags = value;
    }
    get schedulingStrategy() {
        return this._schedulingStrategy;
    }
    set schedulingStrategy(value) {
        this._schedulingStrategy = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get taskDefinition() {
        return this._taskDefinition;
    }
    set taskDefinition(value) {
        this._taskDefinition = value;
    }
    get capacityProviderStrategy() {
        return this._capacityProviderStrategy;
    }
    set capacityProviderStrategy(value) {
        this._capacityProviderStrategy = value;
    }
    get deploymentController() {
        return this._deploymentController;
    }
    set deploymentController(value) {
        this._deploymentController = value;
    }
    get loadBalancer() {
        return this._loadBalancer;
    }
    set loadBalancer(value) {
        this._loadBalancer = value;
    }
    get networkConfiguration() {
        return this._networkConfiguration;
    }
    set networkConfiguration(value) {
        this._networkConfiguration = value;
    }
    get orderedPlacementStrategy() {
        return this._orderedPlacementStrategy;
    }
    set orderedPlacementStrategy(value) {
        this._orderedPlacementStrategy = value;
    }
    get placementConstraints() {
        return this._placementConstraints;
    }
    set placementConstraints(value) {
        this._placementConstraints = value;
    }
    get placementStrategy() {
        return this._placementStrategy;
    }
    set placementStrategy(value) {
        this._placementStrategy = value;
    }
    get serviceRegistries() {
        return this._serviceRegistries;
    }
    set serviceRegistries(value) {
        this._serviceRegistries = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cluster: this._cluster,
            deployment_maximum_percent: this._deploymentMaximumPercent,
            deployment_minimum_healthy_percent: this._deploymentMinimumHealthyPercent,
            desired_count: this._desiredCount,
            enable_ecs_managed_tags: this._enableEcsManagedTags,
            force_new_deployment: this._forceNewDeployment,
            health_check_grace_period_seconds: this._healthCheckGracePeriodSeconds,
            iam_role: this._iamRole,
            launch_type: this._launchType,
            name: this._name,
            platform_version: this._platformVersion,
            propagate_tags: this._propagateTags,
            scheduling_strategy: this._schedulingStrategy,
            tags: this._tags,
            task_definition: this._taskDefinition,
            capacity_provider_strategy: this._capacityProviderStrategy,
            deployment_controller: this._deploymentController,
            load_balancer: this._loadBalancer,
            network_configuration: this._networkConfiguration,
            ordered_placement_strategy: this._orderedPlacementStrategy,
            placement_constraints: this._placementConstraints,
            placement_strategy: this._placementStrategy,
            service_registries: this._serviceRegistries,
            timeouts: this._timeouts,
        };
    }
}
exports.EcsService = EcsService;
//# sourceMappingURL=data:application/json;base64,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