import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EcsTaskDefinitionConfig extends TerraformMetaArguments {
    readonly containerDefinitions: string;
    readonly cpu?: string;
    readonly executionRoleArn?: string;
    readonly family: string;
    readonly ipcMode?: string;
    readonly memory?: string;
    readonly networkMode?: string;
    readonly pidMode?: string;
    readonly requiresCompatibilities?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly taskRoleArn?: string;
    /** inference_accelerator block */
    readonly inferenceAccelerator?: EcsTaskDefinitionInferenceAccelerator[];
    /** placement_constraints block */
    readonly placementConstraints?: EcsTaskDefinitionPlacementConstraints[];
    /** proxy_configuration block */
    readonly proxyConfiguration?: EcsTaskDefinitionProxyConfiguration[];
    /** volume block */
    readonly volume?: EcsTaskDefinitionVolume[];
}
export interface EcsTaskDefinitionInferenceAccelerator {
    readonly deviceName: string;
    readonly deviceType: string;
}
export interface EcsTaskDefinitionPlacementConstraints {
    readonly expression?: string;
    readonly type: string;
}
export interface EcsTaskDefinitionProxyConfiguration {
    readonly containerName: string;
    readonly properties?: {
        [key: string]: string;
    };
    readonly type?: string;
}
export interface EcsTaskDefinitionVolumeDockerVolumeConfiguration {
    readonly autoprovision?: boolean;
    readonly driver?: string;
    readonly driverOpts?: {
        [key: string]: string;
    };
    readonly labels?: {
        [key: string]: string;
    };
    readonly scope?: string;
}
export interface EcsTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig {
    readonly accessPointId?: string;
    readonly iam?: string;
}
export interface EcsTaskDefinitionVolumeEfsVolumeConfiguration {
    readonly fileSystemId: string;
    readonly rootDirectory?: string;
    readonly transitEncryption?: string;
    readonly transitEncryptionPort?: number;
    /** authorization_config block */
    readonly authorizationConfig?: EcsTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig[];
}
export interface EcsTaskDefinitionVolume {
    readonly hostPath?: string;
    readonly name: string;
    /** docker_volume_configuration block */
    readonly dockerVolumeConfiguration?: EcsTaskDefinitionVolumeDockerVolumeConfiguration[];
    /** efs_volume_configuration block */
    readonly efsVolumeConfiguration?: EcsTaskDefinitionVolumeEfsVolumeConfiguration[];
}
export declare class EcsTaskDefinition extends TerraformResource {
    constructor(scope: Construct, id: string, config: EcsTaskDefinitionConfig);
    get arn(): string;
    private _containerDefinitions;
    get containerDefinitions(): string;
    set containerDefinitions(value: string);
    private _cpu?;
    get cpu(): string | undefined;
    set cpu(value: string | undefined);
    private _executionRoleArn?;
    get executionRoleArn(): string | undefined;
    set executionRoleArn(value: string | undefined);
    private _family;
    get family(): string;
    set family(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipcMode?;
    get ipcMode(): string | undefined;
    set ipcMode(value: string | undefined);
    private _memory?;
    get memory(): string | undefined;
    set memory(value: string | undefined);
    private _networkMode?;
    get networkMode(): string | undefined;
    set networkMode(value: string | undefined);
    private _pidMode?;
    get pidMode(): string | undefined;
    set pidMode(value: string | undefined);
    private _requiresCompatibilities?;
    get requiresCompatibilities(): string[] | undefined;
    set requiresCompatibilities(value: string[] | undefined);
    get revision(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _taskRoleArn?;
    get taskRoleArn(): string | undefined;
    set taskRoleArn(value: string | undefined);
    private _inferenceAccelerator?;
    get inferenceAccelerator(): EcsTaskDefinitionInferenceAccelerator[] | undefined;
    set inferenceAccelerator(value: EcsTaskDefinitionInferenceAccelerator[] | undefined);
    private _placementConstraints?;
    get placementConstraints(): EcsTaskDefinitionPlacementConstraints[] | undefined;
    set placementConstraints(value: EcsTaskDefinitionPlacementConstraints[] | undefined);
    private _proxyConfiguration?;
    get proxyConfiguration(): EcsTaskDefinitionProxyConfiguration[] | undefined;
    set proxyConfiguration(value: EcsTaskDefinitionProxyConfiguration[] | undefined);
    private _volume?;
    get volume(): EcsTaskDefinitionVolume[] | undefined;
    set volume(value: EcsTaskDefinitionVolume[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
