import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EfsAccessPointConfig extends TerraformMetaArguments {
    readonly fileSystemId: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** posix_user block */
    readonly posixUser?: EfsAccessPointPosixUser[];
    /** root_directory block */
    readonly rootDirectory?: EfsAccessPointRootDirectory[];
}
export interface EfsAccessPointPosixUser {
    readonly gid: number;
    readonly secondaryGids?: number[];
    readonly uid: number;
}
export interface EfsAccessPointRootDirectoryCreationInfo {
    readonly ownerGid: number;
    readonly ownerUid: number;
    readonly permissions: string;
}
export interface EfsAccessPointRootDirectory {
    readonly path?: string;
    /** creation_info block */
    readonly creationInfo?: EfsAccessPointRootDirectoryCreationInfo[];
}
export declare class EfsAccessPoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: EfsAccessPointConfig);
    get arn(): string;
    get fileSystemArn(): string;
    private _fileSystemId;
    get fileSystemId(): string;
    set fileSystemId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _posixUser?;
    get posixUser(): EfsAccessPointPosixUser[] | undefined;
    set posixUser(value: EfsAccessPointPosixUser[] | undefined);
    private _rootDirectory?;
    get rootDirectory(): EfsAccessPointRootDirectory[] | undefined;
    set rootDirectory(value: EfsAccessPointRootDirectory[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
