import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EfsFileSystemConfig extends TerraformMetaArguments {
    readonly creationToken?: string;
    readonly encrypted?: boolean;
    readonly kmsKeyId?: string;
    readonly performanceMode?: string;
    readonly provisionedThroughputInMibps?: number;
    readonly referenceName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly throughputMode?: string;
    /** lifecycle_policy block */
    readonly lifecyclePolicy?: EfsFileSystemLifecyclePolicy[];
}
export interface EfsFileSystemLifecyclePolicy {
    readonly transitionToIa: string;
}
export declare class EfsFileSystem extends TerraformResource {
    constructor(scope: Construct, id: string, config?: EfsFileSystemConfig);
    get arn(): string;
    private _creationToken?;
    get creationToken(): string | undefined;
    set creationToken(value: string | undefined);
    get dnsName(): string;
    private _encrypted?;
    get encrypted(): boolean | undefined;
    set encrypted(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _performanceMode?;
    get performanceMode(): string | undefined;
    set performanceMode(value: string | undefined);
    private _provisionedThroughputInMibps?;
    get provisionedThroughputInMibps(): number | undefined;
    set provisionedThroughputInMibps(value: number | undefined);
    private _referenceName?;
    get referenceName(): string | undefined;
    set referenceName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _throughputMode?;
    get throughputMode(): string | undefined;
    set throughputMode(value: string | undefined);
    private _lifecyclePolicy?;
    get lifecyclePolicy(): EfsFileSystemLifecyclePolicy[] | undefined;
    set lifecyclePolicy(value: EfsFileSystemLifecyclePolicy[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
