import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EfsMountTargetConfig extends TerraformMetaArguments {
    readonly fileSystemId: string;
    readonly ipAddress?: string;
    readonly securityGroups?: string[];
    readonly subnetId: string;
}
export declare class EfsMountTarget extends TerraformResource {
    constructor(scope: Construct, id: string, config: EfsMountTargetConfig);
    get availabilityZoneId(): string;
    get availabilityZoneName(): string;
    get dnsName(): string;
    get fileSystemArn(): string;
    private _fileSystemId;
    get fileSystemId(): string;
    set fileSystemId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddress?;
    get ipAddress(): string | undefined;
    set ipAddress(value: string | undefined);
    get mountTargetDnsName(): string;
    get networkInterfaceId(): string;
    get ownerId(): string;
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _subnetId;
    get subnetId(): string;
    set subnetId(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
