import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EipConfig extends TerraformMetaArguments {
    readonly associateWithPrivateIp?: string;
    readonly customerOwnedIpv4Pool?: string;
    readonly instance?: string;
    readonly networkInterface?: string;
    readonly publicIpv4Pool?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpc?: boolean;
    /** timeouts block */
    readonly timeouts?: EipTimeouts;
}
export interface EipTimeouts {
    readonly delete?: string;
    readonly read?: string;
    readonly update?: string;
}
export declare class Eip extends TerraformResource {
    constructor(scope: Construct, id: string, config?: EipConfig);
    get allocationId(): string;
    private _associateWithPrivateIp?;
    get associateWithPrivateIp(): string | undefined;
    set associateWithPrivateIp(value: string | undefined);
    get associationId(): string;
    get customerOwnedIp(): string;
    private _customerOwnedIpv4Pool?;
    get customerOwnedIpv4Pool(): string | undefined;
    set customerOwnedIpv4Pool(value: string | undefined);
    get domain(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    private _networkInterface?;
    get networkInterface(): string | undefined;
    set networkInterface(value: string | undefined);
    get privateDns(): string;
    get privateIp(): string;
    get publicDns(): string;
    get publicIp(): string;
    private _publicIpv4Pool?;
    get publicIpv4Pool(): string | undefined;
    set publicIpv4Pool(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpc?;
    get vpc(): boolean | undefined;
    set vpc(value: boolean | undefined);
    private _timeouts?;
    get timeouts(): EipTimeouts | undefined;
    set timeouts(value: EipTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
