import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface EksClusterConfig extends TerraformMetaArguments {
    readonly enabledClusterLogTypes?: string[];
    readonly name: string;
    readonly roleArn: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly version?: string;
    /** encryption_config block */
    readonly encryptionConfig?: EksClusterEncryptionConfig[];
    /** timeouts block */
    readonly timeouts?: EksClusterTimeouts;
    /** vpc_config block */
    readonly vpcConfig: EksClusterVpcConfig[];
}
export declare class EksClusterCertificateAuthority extends ComplexComputedList {
    get data(): string;
}
export declare class EksClusterIdentityOidc extends ComplexComputedList {
    get issuer(): string;
}
export declare class EksClusterIdentity extends ComplexComputedList {
    get oidc(): any;
}
export interface EksClusterEncryptionConfigProvider {
    readonly keyArn: string;
}
export interface EksClusterEncryptionConfig {
    readonly resources: string[];
    /** provider block */
    readonly provider: EksClusterEncryptionConfigProvider[];
}
export interface EksClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export interface EksClusterVpcConfig {
    readonly endpointPrivateAccess?: boolean;
    readonly endpointPublicAccess?: boolean;
    readonly publicAccessCidrs?: string[];
    readonly securityGroupIds?: string[];
    readonly subnetIds: string[];
}
export declare class EksCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: EksClusterConfig);
    get arn(): string;
    certificateAuthority(index: string): EksClusterCertificateAuthority;
    get createdAt(): string;
    private _enabledClusterLogTypes?;
    get enabledClusterLogTypes(): string[] | undefined;
    set enabledClusterLogTypes(value: string[] | undefined);
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    identity(index: string): EksClusterIdentity;
    private _name;
    get name(): string;
    set name(value: string);
    get platformVersion(): string;
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    private _encryptionConfig?;
    get encryptionConfig(): EksClusterEncryptionConfig[] | undefined;
    set encryptionConfig(value: EksClusterEncryptionConfig[] | undefined);
    private _timeouts?;
    get timeouts(): EksClusterTimeouts | undefined;
    set timeouts(value: EksClusterTimeouts | undefined);
    private _vpcConfig;
    get vpcConfig(): EksClusterVpcConfig[];
    set vpcConfig(value: EksClusterVpcConfig[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
