import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EksFargateProfileConfig extends TerraformMetaArguments {
    readonly clusterName: string;
    readonly fargateProfileName: string;
    readonly podExecutionRoleArn: string;
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** selector block */
    readonly selector: EksFargateProfileSelector[];
    /** timeouts block */
    readonly timeouts?: EksFargateProfileTimeouts;
}
export interface EksFargateProfileSelector {
    readonly labels?: {
        [key: string]: string;
    };
    readonly namespace: string;
}
export interface EksFargateProfileTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class EksFargateProfile extends TerraformResource {
    constructor(scope: Construct, id: string, config: EksFargateProfileConfig);
    get arn(): string;
    private _clusterName;
    get clusterName(): string;
    set clusterName(value: string);
    private _fargateProfileName;
    get fargateProfileName(): string;
    set fargateProfileName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _podExecutionRoleArn;
    get podExecutionRoleArn(): string;
    set podExecutionRoleArn(value: string);
    get status(): string;
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _selector;
    get selector(): EksFargateProfileSelector[];
    set selector(value: EksFargateProfileSelector[]);
    private _timeouts?;
    get timeouts(): EksFargateProfileTimeouts | undefined;
    set timeouts(value: EksFargateProfileTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
