import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface EksNodeGroupConfig extends TerraformMetaArguments {
    readonly amiType?: string;
    readonly clusterName: string;
    readonly diskSize?: number;
    readonly forceUpdateVersion?: boolean;
    readonly instanceTypes?: string[];
    readonly labels?: {
        [key: string]: string;
    };
    readonly nodeGroupName: string;
    readonly nodeRoleArn: string;
    readonly releaseVersion?: string;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly version?: string;
    /** remote_access block */
    readonly remoteAccess?: EksNodeGroupRemoteAccess[];
    /** scaling_config block */
    readonly scalingConfig: EksNodeGroupScalingConfig[];
    /** timeouts block */
    readonly timeouts?: EksNodeGroupTimeouts;
}
export declare class EksNodeGroupResourcesAutoscalingGroups extends ComplexComputedList {
    get name(): string;
}
export declare class EksNodeGroupResources extends ComplexComputedList {
    get autoscalingGroups(): any;
    get remoteAccessSecurityGroupId(): string;
}
export interface EksNodeGroupRemoteAccess {
    readonly ec2SshKey?: string;
    readonly sourceSecurityGroupIds?: string[];
}
export interface EksNodeGroupScalingConfig {
    readonly desiredSize: number;
    readonly maxSize: number;
    readonly minSize: number;
}
export interface EksNodeGroupTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class EksNodeGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: EksNodeGroupConfig);
    private _amiType?;
    get amiType(): string | undefined;
    set amiType(value: string | undefined);
    get arn(): string;
    private _clusterName;
    get clusterName(): string;
    set clusterName(value: string);
    private _diskSize?;
    get diskSize(): number | undefined;
    set diskSize(value: number | undefined);
    private _forceUpdateVersion?;
    get forceUpdateVersion(): boolean | undefined;
    set forceUpdateVersion(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceTypes?;
    get instanceTypes(): string[] | undefined;
    set instanceTypes(value: string[] | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | undefined;
    set labels(value: {
        [key: string]: string;
    } | undefined);
    private _nodeGroupName;
    get nodeGroupName(): string;
    set nodeGroupName(value: string);
    private _nodeRoleArn;
    get nodeRoleArn(): string;
    set nodeRoleArn(value: string);
    private _releaseVersion?;
    get releaseVersion(): string | undefined;
    set releaseVersion(value: string | undefined);
    resources(index: string): EksNodeGroupResources;
    get status(): string;
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    private _remoteAccess?;
    get remoteAccess(): EksNodeGroupRemoteAccess[] | undefined;
    set remoteAccess(value: EksNodeGroupRemoteAccess[] | undefined);
    private _scalingConfig;
    get scalingConfig(): EksNodeGroupScalingConfig[];
    set scalingConfig(value: EksNodeGroupScalingConfig[]);
    private _timeouts?;
    get timeouts(): EksNodeGroupTimeouts | undefined;
    set timeouts(value: EksNodeGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
