"use strict";
// https://www.terraform.io/docs/providers/aws/r/eks_node_group.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.EksNodeGroup = exports.EksNodeGroupResources = exports.EksNodeGroupResourcesAutoscalingGroups = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
class EksNodeGroupResourcesAutoscalingGroups extends cdktf_2.ComplexComputedList {
    // name - computed: true, optional: false, required: true
    get name() {
        return this.getStringAttribute('name');
    }
}
exports.EksNodeGroupResourcesAutoscalingGroups = EksNodeGroupResourcesAutoscalingGroups;
class EksNodeGroupResources extends cdktf_2.ComplexComputedList {
    // autoscaling_groups - computed: true, optional: false, required: true
    get autoscalingGroups() {
        return 'not implemented';
    }
    // remote_access_security_group_id - computed: true, optional: false, required: true
    get remoteAccessSecurityGroupId() {
        return this.getStringAttribute('remote_access_security_group_id');
    }
}
exports.EksNodeGroupResources = EksNodeGroupResources;
// Resource
class EksNodeGroup extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_eks_node_group',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._amiType = config.amiType;
        this._clusterName = config.clusterName;
        this._diskSize = config.diskSize;
        this._forceUpdateVersion = config.forceUpdateVersion;
        this._instanceTypes = config.instanceTypes;
        this._labels = config.labels;
        this._nodeGroupName = config.nodeGroupName;
        this._nodeRoleArn = config.nodeRoleArn;
        this._releaseVersion = config.releaseVersion;
        this._subnetIds = config.subnetIds;
        this._tags = config.tags;
        this._version = config.version;
        this._remoteAccess = config.remoteAccess;
        this._scalingConfig = config.scalingConfig;
        this._timeouts = config.timeouts;
    }
    get amiType() {
        var _a;
        return (_a = this._amiType) !== null && _a !== void 0 ? _a : this.getStringAttribute('ami_type');
    }
    set amiType(value) {
        this._amiType = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get clusterName() {
        return this._clusterName;
    }
    set clusterName(value) {
        this._clusterName = value;
    }
    get diskSize() {
        var _a;
        return (_a = this._diskSize) !== null && _a !== void 0 ? _a : this.getNumberAttribute('disk_size');
    }
    set diskSize(value) {
        this._diskSize = value;
    }
    get forceUpdateVersion() {
        return this._forceUpdateVersion;
    }
    set forceUpdateVersion(value) {
        this._forceUpdateVersion = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get instanceTypes() {
        var _a;
        return (_a = this._instanceTypes) !== null && _a !== void 0 ? _a : this.getListAttribute('instance_types');
    }
    set instanceTypes(value) {
        this._instanceTypes = value;
    }
    get labels() {
        return this._labels;
    }
    set labels(value) {
        this._labels = value;
    }
    get nodeGroupName() {
        return this._nodeGroupName;
    }
    set nodeGroupName(value) {
        this._nodeGroupName = value;
    }
    get nodeRoleArn() {
        return this._nodeRoleArn;
    }
    set nodeRoleArn(value) {
        this._nodeRoleArn = value;
    }
    get releaseVersion() {
        var _a;
        return (_a = this._releaseVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('release_version');
    }
    set releaseVersion(value) {
        this._releaseVersion = value;
    }
    // resources - computed: true, optional: false, required: true
    resources(index) {
        return new EksNodeGroupResources(this, 'resources', index);
    }
    // status - computed: true, optional: false, required: true
    get status() {
        return this.getStringAttribute('status');
    }
    get subnetIds() {
        return this._subnetIds;
    }
    set subnetIds(value) {
        this._subnetIds = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get version() {
        var _a;
        return (_a = this._version) !== null && _a !== void 0 ? _a : this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    get remoteAccess() {
        return this._remoteAccess;
    }
    set remoteAccess(value) {
        this._remoteAccess = value;
    }
    get scalingConfig() {
        return this._scalingConfig;
    }
    set scalingConfig(value) {
        this._scalingConfig = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ami_type: this._amiType,
            cluster_name: this._clusterName,
            disk_size: this._diskSize,
            force_update_version: this._forceUpdateVersion,
            instance_types: this._instanceTypes,
            labels: this._labels,
            node_group_name: this._nodeGroupName,
            node_role_arn: this._nodeRoleArn,
            release_version: this._releaseVersion,
            subnet_ids: this._subnetIds,
            tags: this._tags,
            version: this._version,
            remote_access: this._remoteAccess,
            scaling_config: this._scalingConfig,
            timeouts: this._timeouts,
        };
    }
}
exports.EksNodeGroup = EksNodeGroup;
//# sourceMappingURL=data:application/json;base64,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