import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticBeanstalkApplicationVersionConfig extends TerraformMetaArguments {
    readonly application: string;
    readonly bucket: string;
    readonly description?: string;
    readonly forceDelete?: boolean;
    readonly key: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class ElasticBeanstalkApplicationVersion extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticBeanstalkApplicationVersionConfig);
    private _application;
    get application(): string;
    set application(value: string);
    get arn(): string;
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _forceDelete?;
    get forceDelete(): boolean | undefined;
    set forceDelete(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _key;
    get key(): string;
    set key(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
