import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticBeanstalkApplicationConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** appversion_lifecycle block */
    readonly appversionLifecycle?: ElasticBeanstalkApplicationAppversionLifecycle[];
}
export interface ElasticBeanstalkApplicationAppversionLifecycle {
    readonly deleteSourceFromS3?: boolean;
    readonly maxAgeInDays?: number;
    readonly maxCount?: number;
    readonly serviceRole: string;
}
export declare class ElasticBeanstalkApplication extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticBeanstalkApplicationConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _appversionLifecycle?;
    get appversionLifecycle(): ElasticBeanstalkApplicationAppversionLifecycle[] | undefined;
    set appversionLifecycle(value: ElasticBeanstalkApplicationAppversionLifecycle[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
