import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticBeanstalkConfigurationTemplateConfig extends TerraformMetaArguments {
    readonly application: string;
    readonly description?: string;
    readonly environmentId?: string;
    readonly name: string;
    readonly solutionStackName?: string;
    /** setting block */
    readonly setting?: ElasticBeanstalkConfigurationTemplateSetting[];
}
export interface ElasticBeanstalkConfigurationTemplateSetting {
    readonly name: string;
    readonly namespace: string;
    readonly resource?: string;
    readonly value: string;
}
export declare class ElasticBeanstalkConfigurationTemplate extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticBeanstalkConfigurationTemplateConfig);
    private _application;
    get application(): string;
    set application(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _environmentId?;
    get environmentId(): string | undefined;
    set environmentId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _solutionStackName?;
    get solutionStackName(): string | undefined;
    set solutionStackName(value: string | undefined);
    private _setting?;
    get setting(): ElasticBeanstalkConfigurationTemplateSetting[] | undefined;
    set setting(value: ElasticBeanstalkConfigurationTemplateSetting[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
