import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface ElasticBeanstalkEnvironmentConfig extends TerraformMetaArguments {
    readonly application: string;
    readonly cnamePrefix?: string;
    readonly description?: string;
    readonly name: string;
    readonly platformArn?: string;
    readonly pollInterval?: string;
    readonly solutionStackName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly templateName?: string;
    readonly tier?: string;
    readonly versionLabel?: string;
    readonly waitForReadyTimeout?: string;
    /** setting block */
    readonly setting?: ElasticBeanstalkEnvironmentSetting[];
}
export declare class ElasticBeanstalkEnvironmentAllSettings extends ComplexComputedList {
    get name(): string;
    get namespace(): string;
    get resource(): string;
    get value(): string;
}
export interface ElasticBeanstalkEnvironmentSetting {
    readonly name: string;
    readonly namespace: string;
    readonly resource?: string;
    readonly value: string;
}
export declare class ElasticBeanstalkEnvironment extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticBeanstalkEnvironmentConfig);
    allSettings(index: string): ElasticBeanstalkEnvironmentAllSettings;
    private _application;
    get application(): string;
    set application(value: string);
    get arn(): string;
    get autoscalingGroups(): string[];
    get cname(): string;
    private _cnamePrefix?;
    get cnamePrefix(): string | undefined;
    set cnamePrefix(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get endpointUrl(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get instances(): string[];
    get launchConfigurations(): string[];
    get loadBalancers(): string[];
    private _name;
    get name(): string;
    set name(value: string);
    private _platformArn?;
    get platformArn(): string | undefined;
    set platformArn(value: string | undefined);
    private _pollInterval?;
    get pollInterval(): string | undefined;
    set pollInterval(value: string | undefined);
    get queues(): string[];
    private _solutionStackName?;
    get solutionStackName(): string | undefined;
    set solutionStackName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _templateName?;
    get templateName(): string | undefined;
    set templateName(value: string | undefined);
    private _tier?;
    get tier(): string | undefined;
    set tier(value: string | undefined);
    get triggers(): string[];
    private _versionLabel?;
    get versionLabel(): string | undefined;
    set versionLabel(value: string | undefined);
    private _waitForReadyTimeout?;
    get waitForReadyTimeout(): string | undefined;
    set waitForReadyTimeout(value: string | undefined);
    private _setting?;
    get setting(): ElasticBeanstalkEnvironmentSetting[] | undefined;
    set setting(value: ElasticBeanstalkEnvironmentSetting[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
