import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface ElasticacheClusterConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly availabilityZone?: string;
    readonly availabilityZones?: string[];
    readonly azMode?: string;
    readonly clusterId: string;
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly maintenanceWindow?: string;
    readonly nodeType?: string;
    readonly notificationTopicArn?: string;
    readonly numCacheNodes?: number;
    readonly parameterGroupName?: string;
    readonly port?: number;
    readonly preferredAvailabilityZones?: string[];
    readonly replicationGroupId?: string;
    readonly securityGroupIds?: string[];
    readonly securityGroupNames?: string[];
    readonly snapshotArns?: string[];
    readonly snapshotName?: string;
    readonly snapshotRetentionLimit?: number;
    readonly snapshotWindow?: string;
    readonly subnetGroupName?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class ElasticacheClusterCacheNodes extends ComplexComputedList {
    get address(): string;
    get availabilityZone(): string;
    get id(): string;
    get port(): number;
}
export declare class ElasticacheCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticacheClusterConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _azMode?;
    get azMode(): string | undefined;
    set azMode(value: string | undefined);
    cacheNodes(index: string): ElasticacheClusterCacheNodes;
    get clusterAddress(): string;
    private _clusterId;
    get clusterId(): string;
    set clusterId(value: string);
    get configurationEndpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maintenanceWindow?;
    get maintenanceWindow(): string | undefined;
    set maintenanceWindow(value: string | undefined);
    private _nodeType?;
    get nodeType(): string | undefined;
    set nodeType(value: string | undefined);
    private _notificationTopicArn?;
    get notificationTopicArn(): string | undefined;
    set notificationTopicArn(value: string | undefined);
    private _numCacheNodes?;
    get numCacheNodes(): number | undefined;
    set numCacheNodes(value: number | undefined);
    private _parameterGroupName?;
    get parameterGroupName(): string | undefined;
    set parameterGroupName(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredAvailabilityZones?;
    get preferredAvailabilityZones(): string[] | undefined;
    set preferredAvailabilityZones(value: string[] | undefined);
    private _replicationGroupId?;
    get replicationGroupId(): string | undefined;
    set replicationGroupId(value: string | undefined);
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _securityGroupNames?;
    get securityGroupNames(): string[] | undefined;
    set securityGroupNames(value: string[] | undefined);
    private _snapshotArns?;
    get snapshotArns(): string[] | undefined;
    set snapshotArns(value: string[] | undefined);
    private _snapshotName?;
    get snapshotName(): string | undefined;
    set snapshotName(value: string | undefined);
    private _snapshotRetentionLimit?;
    get snapshotRetentionLimit(): number | undefined;
    set snapshotRetentionLimit(value: number | undefined);
    private _snapshotWindow?;
    get snapshotWindow(): string | undefined;
    set snapshotWindow(value: string | undefined);
    private _subnetGroupName?;
    get subnetGroupName(): string | undefined;
    set subnetGroupName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
