import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticacheParameterGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly family: string;
    readonly name: string;
    /** parameter block */
    readonly parameter?: ElasticacheParameterGroupParameter[];
}
export interface ElasticacheParameterGroupParameter {
    readonly name: string;
    readonly value: string;
}
export declare class ElasticacheParameterGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticacheParameterGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _family;
    get family(): string;
    set family(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameter?;
    get parameter(): ElasticacheParameterGroupParameter[] | undefined;
    set parameter(value: ElasticacheParameterGroupParameter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
