import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticacheReplicationGroupConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly atRestEncryptionEnabled?: boolean;
    readonly authToken?: string;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly automaticFailoverEnabled?: boolean;
    readonly availabilityZones?: string[];
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly kmsKeyId?: string;
    readonly maintenanceWindow?: string;
    readonly nodeType?: string;
    readonly notificationTopicArn?: string;
    readonly numberCacheClusters?: number;
    readonly parameterGroupName?: string;
    readonly port?: number;
    readonly replicationGroupDescription: string;
    readonly replicationGroupId: string;
    readonly securityGroupIds?: string[];
    readonly securityGroupNames?: string[];
    readonly snapshotArns?: string[];
    readonly snapshotName?: string;
    readonly snapshotRetentionLimit?: number;
    readonly snapshotWindow?: string;
    readonly subnetGroupName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly transitEncryptionEnabled?: boolean;
    /** cluster_mode block */
    readonly clusterMode?: ElasticacheReplicationGroupClusterMode[];
    /** timeouts block */
    readonly timeouts?: ElasticacheReplicationGroupTimeouts;
}
export interface ElasticacheReplicationGroupClusterMode {
    readonly numNodeGroups: number;
    readonly replicasPerNodeGroup: number;
}
export interface ElasticacheReplicationGroupTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class ElasticacheReplicationGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticacheReplicationGroupConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    private _atRestEncryptionEnabled?;
    get atRestEncryptionEnabled(): boolean | undefined;
    set atRestEncryptionEnabled(value: boolean | undefined);
    private _authToken?;
    get authToken(): string | undefined;
    set authToken(value: string | undefined);
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _automaticFailoverEnabled?;
    get automaticFailoverEnabled(): boolean | undefined;
    set automaticFailoverEnabled(value: boolean | undefined);
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    get configurationEndpointAddress(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _maintenanceWindow?;
    get maintenanceWindow(): string | undefined;
    set maintenanceWindow(value: string | undefined);
    get memberClusters(): string[];
    private _nodeType?;
    get nodeType(): string | undefined;
    set nodeType(value: string | undefined);
    private _notificationTopicArn?;
    get notificationTopicArn(): string | undefined;
    set notificationTopicArn(value: string | undefined);
    private _numberCacheClusters?;
    get numberCacheClusters(): number | undefined;
    set numberCacheClusters(value: number | undefined);
    private _parameterGroupName?;
    get parameterGroupName(): string | undefined;
    set parameterGroupName(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    get primaryEndpointAddress(): string;
    private _replicationGroupDescription;
    get replicationGroupDescription(): string;
    set replicationGroupDescription(value: string);
    private _replicationGroupId;
    get replicationGroupId(): string;
    set replicationGroupId(value: string);
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _securityGroupNames?;
    get securityGroupNames(): string[] | undefined;
    set securityGroupNames(value: string[] | undefined);
    private _snapshotArns?;
    get snapshotArns(): string[] | undefined;
    set snapshotArns(value: string[] | undefined);
    private _snapshotName?;
    get snapshotName(): string | undefined;
    set snapshotName(value: string | undefined);
    private _snapshotRetentionLimit?;
    get snapshotRetentionLimit(): number | undefined;
    set snapshotRetentionLimit(value: number | undefined);
    private _snapshotWindow?;
    get snapshotWindow(): string | undefined;
    set snapshotWindow(value: string | undefined);
    private _subnetGroupName?;
    get subnetGroupName(): string | undefined;
    set subnetGroupName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _transitEncryptionEnabled?;
    get transitEncryptionEnabled(): boolean | undefined;
    set transitEncryptionEnabled(value: boolean | undefined);
    private _clusterMode?;
    get clusterMode(): ElasticacheReplicationGroupClusterMode[] | undefined;
    set clusterMode(value: ElasticacheReplicationGroupClusterMode[] | undefined);
    private _timeouts?;
    get timeouts(): ElasticacheReplicationGroupTimeouts | undefined;
    set timeouts(value: ElasticacheReplicationGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
