import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElasticsearchDomainConfig extends TerraformMetaArguments {
    readonly accessPolicies?: string;
    readonly advancedOptions?: {
        [key: string]: string;
    };
    readonly domainName: string;
    readonly elasticsearchVersion?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** advanced_security_options block */
    readonly advancedSecurityOptions?: ElasticsearchDomainAdvancedSecurityOptions[];
    /** cluster_config block */
    readonly clusterConfig?: ElasticsearchDomainClusterConfig[];
    /** cognito_options block */
    readonly cognitoOptions?: ElasticsearchDomainCognitoOptions[];
    /** domain_endpoint_options block */
    readonly domainEndpointOptions?: ElasticsearchDomainDomainEndpointOptions[];
    /** ebs_options block */
    readonly ebsOptions?: ElasticsearchDomainEbsOptions[];
    /** encrypt_at_rest block */
    readonly encryptAtRest?: ElasticsearchDomainEncryptAtRest[];
    /** log_publishing_options block */
    readonly logPublishingOptions?: ElasticsearchDomainLogPublishingOptions[];
    /** node_to_node_encryption block */
    readonly nodeToNodeEncryption?: ElasticsearchDomainNodeToNodeEncryption[];
    /** snapshot_options block */
    readonly snapshotOptions?: ElasticsearchDomainSnapshotOptions[];
    /** timeouts block */
    readonly timeouts?: ElasticsearchDomainTimeouts;
    /** vpc_options block */
    readonly vpcOptions?: ElasticsearchDomainVpcOptions[];
}
export interface ElasticsearchDomainAdvancedSecurityOptionsMasterUserOptions {
    readonly masterUserArn?: string;
    readonly masterUserName?: string;
    readonly masterUserPassword?: string;
}
export interface ElasticsearchDomainAdvancedSecurityOptions {
    readonly enabled: boolean;
    readonly internalUserDatabaseEnabled?: boolean;
    /** master_user_options block */
    readonly masterUserOptions?: ElasticsearchDomainAdvancedSecurityOptionsMasterUserOptions[];
}
export interface ElasticsearchDomainClusterConfigZoneAwarenessConfig {
    readonly availabilityZoneCount?: number;
}
export interface ElasticsearchDomainClusterConfig {
    readonly dedicatedMasterCount?: number;
    readonly dedicatedMasterEnabled?: boolean;
    readonly dedicatedMasterType?: string;
    readonly instanceCount?: number;
    readonly instanceType?: string;
    readonly warmCount?: number;
    readonly warmEnabled?: boolean;
    readonly warmType?: string;
    readonly zoneAwarenessEnabled?: boolean;
    /** zone_awareness_config block */
    readonly zoneAwarenessConfig?: ElasticsearchDomainClusterConfigZoneAwarenessConfig[];
}
export interface ElasticsearchDomainCognitoOptions {
    readonly enabled?: boolean;
    readonly identityPoolId: string;
    readonly roleArn: string;
    readonly userPoolId: string;
}
export interface ElasticsearchDomainDomainEndpointOptions {
    readonly enforceHttps: boolean;
    readonly tlsSecurityPolicy?: string;
}
export interface ElasticsearchDomainEbsOptions {
    readonly ebsEnabled: boolean;
    readonly iops?: number;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface ElasticsearchDomainEncryptAtRest {
    readonly enabled: boolean;
    readonly kmsKeyId?: string;
}
export interface ElasticsearchDomainLogPublishingOptions {
    readonly cloudwatchLogGroupArn: string;
    readonly enabled?: boolean;
    readonly logType: string;
}
export interface ElasticsearchDomainNodeToNodeEncryption {
    readonly enabled: boolean;
}
export interface ElasticsearchDomainSnapshotOptions {
    readonly automatedSnapshotStartHour: number;
}
export interface ElasticsearchDomainTimeouts {
    readonly update?: string;
}
export interface ElasticsearchDomainVpcOptions {
    readonly securityGroupIds?: string[];
    readonly subnetIds?: string[];
}
export declare class ElasticsearchDomain extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElasticsearchDomainConfig);
    private _accessPolicies?;
    get accessPolicies(): string | undefined;
    set accessPolicies(value: string | undefined);
    private _advancedOptions?;
    get advancedOptions(): {
        [key: string]: string;
    } | undefined;
    set advancedOptions(value: {
        [key: string]: string;
    } | undefined);
    get arn(): string;
    get domainId(): string;
    private _domainName;
    get domainName(): string;
    set domainName(value: string);
    private _elasticsearchVersion?;
    get elasticsearchVersion(): string | undefined;
    set elasticsearchVersion(value: string | undefined);
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kibanaEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _advancedSecurityOptions?;
    get advancedSecurityOptions(): ElasticsearchDomainAdvancedSecurityOptions[] | undefined;
    set advancedSecurityOptions(value: ElasticsearchDomainAdvancedSecurityOptions[] | undefined);
    private _clusterConfig?;
    get clusterConfig(): ElasticsearchDomainClusterConfig[] | undefined;
    set clusterConfig(value: ElasticsearchDomainClusterConfig[] | undefined);
    private _cognitoOptions?;
    get cognitoOptions(): ElasticsearchDomainCognitoOptions[] | undefined;
    set cognitoOptions(value: ElasticsearchDomainCognitoOptions[] | undefined);
    private _domainEndpointOptions?;
    get domainEndpointOptions(): ElasticsearchDomainDomainEndpointOptions[] | undefined;
    set domainEndpointOptions(value: ElasticsearchDomainDomainEndpointOptions[] | undefined);
    private _ebsOptions?;
    get ebsOptions(): ElasticsearchDomainEbsOptions[] | undefined;
    set ebsOptions(value: ElasticsearchDomainEbsOptions[] | undefined);
    private _encryptAtRest?;
    get encryptAtRest(): ElasticsearchDomainEncryptAtRest[] | undefined;
    set encryptAtRest(value: ElasticsearchDomainEncryptAtRest[] | undefined);
    private _logPublishingOptions?;
    get logPublishingOptions(): ElasticsearchDomainLogPublishingOptions[] | undefined;
    set logPublishingOptions(value: ElasticsearchDomainLogPublishingOptions[] | undefined);
    private _nodeToNodeEncryption?;
    get nodeToNodeEncryption(): ElasticsearchDomainNodeToNodeEncryption[] | undefined;
    set nodeToNodeEncryption(value: ElasticsearchDomainNodeToNodeEncryption[] | undefined);
    private _snapshotOptions?;
    get snapshotOptions(): ElasticsearchDomainSnapshotOptions[] | undefined;
    set snapshotOptions(value: ElasticsearchDomainSnapshotOptions[] | undefined);
    private _timeouts?;
    get timeouts(): ElasticsearchDomainTimeouts | undefined;
    set timeouts(value: ElasticsearchDomainTimeouts | undefined);
    private _vpcOptions?;
    get vpcOptions(): ElasticsearchDomainVpcOptions[] | undefined;
    set vpcOptions(value: ElasticsearchDomainVpcOptions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
