"use strict";
// https://www.terraform.io/docs/providers/aws/r/elasticsearch_domain.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchDomain = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ElasticsearchDomain extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_elasticsearch_domain',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._accessPolicies = config.accessPolicies;
        this._advancedOptions = config.advancedOptions;
        this._domainName = config.domainName;
        this._elasticsearchVersion = config.elasticsearchVersion;
        this._tags = config.tags;
        this._advancedSecurityOptions = config.advancedSecurityOptions;
        this._clusterConfig = config.clusterConfig;
        this._cognitoOptions = config.cognitoOptions;
        this._domainEndpointOptions = config.domainEndpointOptions;
        this._ebsOptions = config.ebsOptions;
        this._encryptAtRest = config.encryptAtRest;
        this._logPublishingOptions = config.logPublishingOptions;
        this._nodeToNodeEncryption = config.nodeToNodeEncryption;
        this._snapshotOptions = config.snapshotOptions;
        this._timeouts = config.timeouts;
        this._vpcOptions = config.vpcOptions;
    }
    get accessPolicies() {
        var _a;
        return (_a = this._accessPolicies) !== null && _a !== void 0 ? _a : this.getStringAttribute('access_policies');
    }
    set accessPolicies(value) {
        this._accessPolicies = value;
    }
    get advancedOptions() {
        return this._advancedOptions; // Getting the computed value is not yet implemented
    }
    set advancedOptions(value) {
        this._advancedOptions = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // domain_id - computed: true, optional: false, required: true
    get domainId() {
        return this.getStringAttribute('domain_id');
    }
    get domainName() {
        return this._domainName;
    }
    set domainName(value) {
        this._domainName = value;
    }
    get elasticsearchVersion() {
        return this._elasticsearchVersion;
    }
    set elasticsearchVersion(value) {
        this._elasticsearchVersion = value;
    }
    // endpoint - computed: true, optional: false, required: true
    get endpoint() {
        return this.getStringAttribute('endpoint');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // kibana_endpoint - computed: true, optional: false, required: true
    get kibanaEndpoint() {
        return this.getStringAttribute('kibana_endpoint');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get advancedSecurityOptions() {
        return this._advancedSecurityOptions;
    }
    set advancedSecurityOptions(value) {
        this._advancedSecurityOptions = value;
    }
    get clusterConfig() {
        return this._clusterConfig;
    }
    set clusterConfig(value) {
        this._clusterConfig = value;
    }
    get cognitoOptions() {
        return this._cognitoOptions;
    }
    set cognitoOptions(value) {
        this._cognitoOptions = value;
    }
    get domainEndpointOptions() {
        return this._domainEndpointOptions;
    }
    set domainEndpointOptions(value) {
        this._domainEndpointOptions = value;
    }
    get ebsOptions() {
        return this._ebsOptions;
    }
    set ebsOptions(value) {
        this._ebsOptions = value;
    }
    get encryptAtRest() {
        return this._encryptAtRest;
    }
    set encryptAtRest(value) {
        this._encryptAtRest = value;
    }
    get logPublishingOptions() {
        return this._logPublishingOptions;
    }
    set logPublishingOptions(value) {
        this._logPublishingOptions = value;
    }
    get nodeToNodeEncryption() {
        return this._nodeToNodeEncryption;
    }
    set nodeToNodeEncryption(value) {
        this._nodeToNodeEncryption = value;
    }
    get snapshotOptions() {
        return this._snapshotOptions;
    }
    set snapshotOptions(value) {
        this._snapshotOptions = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    get vpcOptions() {
        return this._vpcOptions;
    }
    set vpcOptions(value) {
        this._vpcOptions = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_policies: this._accessPolicies,
            advanced_options: this._advancedOptions,
            domain_name: this._domainName,
            elasticsearch_version: this._elasticsearchVersion,
            tags: this._tags,
            advanced_security_options: this._advancedSecurityOptions,
            cluster_config: this._clusterConfig,
            cognito_options: this._cognitoOptions,
            domain_endpoint_options: this._domainEndpointOptions,
            ebs_options: this._ebsOptions,
            encrypt_at_rest: this._encryptAtRest,
            log_publishing_options: this._logPublishingOptions,
            node_to_node_encryption: this._nodeToNodeEncryption,
            snapshot_options: this._snapshotOptions,
            timeouts: this._timeouts,
            vpc_options: this._vpcOptions,
        };
    }
}
exports.ElasticsearchDomain = ElasticsearchDomain;
//# sourceMappingURL=data:application/json;base64,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