import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElastictranscoderPipelineConfig extends TerraformMetaArguments {
    readonly awsKmsKeyArn?: string;
    readonly inputBucket: string;
    readonly name?: string;
    readonly outputBucket?: string;
    readonly role: string;
    /** content_config block */
    readonly contentConfig?: ElastictranscoderPipelineContentConfig[];
    /** content_config_permissions block */
    readonly contentConfigPermissions?: ElastictranscoderPipelineContentConfigPermissions[];
    /** notifications block */
    readonly notifications?: ElastictranscoderPipelineNotifications[];
    /** thumbnail_config block */
    readonly thumbnailConfig?: ElastictranscoderPipelineThumbnailConfig[];
    /** thumbnail_config_permissions block */
    readonly thumbnailConfigPermissions?: ElastictranscoderPipelineThumbnailConfigPermissions[];
}
export interface ElastictranscoderPipelineContentConfig {
    readonly bucket?: string;
    readonly storageClass?: string;
}
export interface ElastictranscoderPipelineContentConfigPermissions {
    readonly access?: string[];
    readonly grantee?: string;
    readonly granteeType?: string;
}
export interface ElastictranscoderPipelineNotifications {
    readonly completed?: string;
    readonly error?: string;
    readonly progressing?: string;
    readonly warning?: string;
}
export interface ElastictranscoderPipelineThumbnailConfig {
    readonly bucket?: string;
    readonly storageClass?: string;
}
export interface ElastictranscoderPipelineThumbnailConfigPermissions {
    readonly access?: string[];
    readonly grantee?: string;
    readonly granteeType?: string;
}
export declare class ElastictranscoderPipeline extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElastictranscoderPipelineConfig);
    get arn(): string;
    private _awsKmsKeyArn?;
    get awsKmsKeyArn(): string | undefined;
    set awsKmsKeyArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _inputBucket;
    get inputBucket(): string;
    set inputBucket(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _outputBucket?;
    get outputBucket(): string | undefined;
    set outputBucket(value: string | undefined);
    private _role;
    get role(): string;
    set role(value: string);
    private _contentConfig?;
    get contentConfig(): ElastictranscoderPipelineContentConfig[] | undefined;
    set contentConfig(value: ElastictranscoderPipelineContentConfig[] | undefined);
    private _contentConfigPermissions?;
    get contentConfigPermissions(): ElastictranscoderPipelineContentConfigPermissions[] | undefined;
    set contentConfigPermissions(value: ElastictranscoderPipelineContentConfigPermissions[] | undefined);
    private _notifications?;
    get notifications(): ElastictranscoderPipelineNotifications[] | undefined;
    set notifications(value: ElastictranscoderPipelineNotifications[] | undefined);
    private _thumbnailConfig?;
    get thumbnailConfig(): ElastictranscoderPipelineThumbnailConfig[] | undefined;
    set thumbnailConfig(value: ElastictranscoderPipelineThumbnailConfig[] | undefined);
    private _thumbnailConfigPermissions?;
    get thumbnailConfigPermissions(): ElastictranscoderPipelineThumbnailConfigPermissions[] | undefined;
    set thumbnailConfigPermissions(value: ElastictranscoderPipelineThumbnailConfigPermissions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
