"use strict";
// https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastictranscoderPipeline = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ElastictranscoderPipeline extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_elastictranscoder_pipeline',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._awsKmsKeyArn = config.awsKmsKeyArn;
        this._inputBucket = config.inputBucket;
        this._name = config.name;
        this._outputBucket = config.outputBucket;
        this._role = config.role;
        this._contentConfig = config.contentConfig;
        this._contentConfigPermissions = config.contentConfigPermissions;
        this._notifications = config.notifications;
        this._thumbnailConfig = config.thumbnailConfig;
        this._thumbnailConfigPermissions = config.thumbnailConfigPermissions;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get awsKmsKeyArn() {
        return this._awsKmsKeyArn;
    }
    set awsKmsKeyArn(value) {
        this._awsKmsKeyArn = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get inputBucket() {
        return this._inputBucket;
    }
    set inputBucket(value) {
        this._inputBucket = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get outputBucket() {
        var _a;
        return (_a = this._outputBucket) !== null && _a !== void 0 ? _a : this.getStringAttribute('output_bucket');
    }
    set outputBucket(value) {
        this._outputBucket = value;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    get contentConfig() {
        return this._contentConfig;
    }
    set contentConfig(value) {
        this._contentConfig = value;
    }
    get contentConfigPermissions() {
        return this._contentConfigPermissions;
    }
    set contentConfigPermissions(value) {
        this._contentConfigPermissions = value;
    }
    get notifications() {
        return this._notifications;
    }
    set notifications(value) {
        this._notifications = value;
    }
    get thumbnailConfig() {
        return this._thumbnailConfig;
    }
    set thumbnailConfig(value) {
        this._thumbnailConfig = value;
    }
    get thumbnailConfigPermissions() {
        return this._thumbnailConfigPermissions;
    }
    set thumbnailConfigPermissions(value) {
        this._thumbnailConfigPermissions = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_kms_key_arn: this._awsKmsKeyArn,
            input_bucket: this._inputBucket,
            name: this._name,
            output_bucket: this._outputBucket,
            role: this._role,
            content_config: this._contentConfig,
            content_config_permissions: this._contentConfigPermissions,
            notifications: this._notifications,
            thumbnail_config: this._thumbnailConfig,
            thumbnail_config_permissions: this._thumbnailConfigPermissions,
        };
    }
}
exports.ElastictranscoderPipeline = ElastictranscoderPipeline;
//# sourceMappingURL=data:application/json;base64,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