import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElastictranscoderPresetConfig extends TerraformMetaArguments {
    readonly container: string;
    readonly description?: string;
    readonly name?: string;
    readonly type?: string;
    readonly videoCodecOptions?: {
        [key: string]: string;
    };
    /** audio block */
    readonly audio?: ElastictranscoderPresetAudio[];
    /** audio_codec_options block */
    readonly audioCodecOptions?: ElastictranscoderPresetAudioCodecOptions[];
    /** thumbnails block */
    readonly thumbnails?: ElastictranscoderPresetThumbnails[];
    /** video block */
    readonly video?: ElastictranscoderPresetVideo[];
    /** video_watermarks block */
    readonly videoWatermarks?: ElastictranscoderPresetVideoWatermarks[];
}
export interface ElastictranscoderPresetAudio {
    readonly audioPackingMode?: string;
    readonly bitRate?: string;
    readonly channels?: string;
    readonly codec?: string;
    readonly sampleRate?: string;
}
export interface ElastictranscoderPresetAudioCodecOptions {
    readonly bitDepth?: string;
    readonly bitOrder?: string;
    readonly profile?: string;
    readonly signed?: string;
}
export interface ElastictranscoderPresetThumbnails {
    readonly aspectRatio?: string;
    readonly format?: string;
    readonly interval?: string;
    readonly maxHeight?: string;
    readonly maxWidth?: string;
    readonly paddingPolicy?: string;
    readonly resolution?: string;
    readonly sizingPolicy?: string;
}
export interface ElastictranscoderPresetVideo {
    readonly aspectRatio?: string;
    readonly bitRate?: string;
    readonly codec?: string;
    readonly displayAspectRatio?: string;
    readonly fixedGop?: string;
    readonly frameRate?: string;
    readonly keyframesMaxDist?: string;
    readonly maxFrameRate?: string;
    readonly maxHeight?: string;
    readonly maxWidth?: string;
    readonly paddingPolicy?: string;
    readonly resolution?: string;
    readonly sizingPolicy?: string;
}
export interface ElastictranscoderPresetVideoWatermarks {
    readonly horizontalAlign?: string;
    readonly horizontalOffset?: string;
    readonly id?: string;
    readonly maxHeight?: string;
    readonly maxWidth?: string;
    readonly opacity?: string;
    readonly sizingPolicy?: string;
    readonly target?: string;
    readonly verticalAlign?: string;
    readonly verticalOffset?: string;
}
export declare class ElastictranscoderPreset extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElastictranscoderPresetConfig);
    get arn(): string;
    private _container;
    get container(): string;
    set container(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    private _videoCodecOptions?;
    get videoCodecOptions(): {
        [key: string]: string;
    } | undefined;
    set videoCodecOptions(value: {
        [key: string]: string;
    } | undefined);
    private _audio?;
    get audio(): ElastictranscoderPresetAudio[] | undefined;
    set audio(value: ElastictranscoderPresetAudio[] | undefined);
    private _audioCodecOptions?;
    get audioCodecOptions(): ElastictranscoderPresetAudioCodecOptions[] | undefined;
    set audioCodecOptions(value: ElastictranscoderPresetAudioCodecOptions[] | undefined);
    private _thumbnails?;
    get thumbnails(): ElastictranscoderPresetThumbnails[] | undefined;
    set thumbnails(value: ElastictranscoderPresetThumbnails[] | undefined);
    private _video?;
    get video(): ElastictranscoderPresetVideo[] | undefined;
    set video(value: ElastictranscoderPresetVideo[] | undefined);
    private _videoWatermarks?;
    get videoWatermarks(): ElastictranscoderPresetVideoWatermarks[] | undefined;
    set videoWatermarks(value: ElastictranscoderPresetVideoWatermarks[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
