import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ElbConfig extends TerraformMetaArguments {
    readonly availabilityZones?: string[];
    readonly connectionDraining?: boolean;
    readonly connectionDrainingTimeout?: number;
    readonly crossZoneLoadBalancing?: boolean;
    readonly idleTimeout?: number;
    readonly instances?: string[];
    readonly internal?: boolean;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly securityGroups?: string[];
    readonly sourceSecurityGroup?: string;
    readonly subnets?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** access_logs block */
    readonly accessLogs?: ElbAccessLogs[];
    /** health_check block */
    readonly healthCheck?: ElbHealthCheck[];
    /** listener block */
    readonly listener: ElbListener[];
}
export interface ElbAccessLogs {
    readonly bucket: string;
    readonly bucketPrefix?: string;
    readonly enabled?: boolean;
    readonly interval?: number;
}
export interface ElbHealthCheck {
    readonly healthyThreshold: number;
    readonly interval: number;
    readonly target: string;
    readonly timeout: number;
    readonly unhealthyThreshold: number;
}
export interface ElbListener {
    readonly instancePort: number;
    readonly instanceProtocol: string;
    readonly lbPort: number;
    readonly lbProtocol: string;
    readonly sslCertificateId?: string;
}
export declare class Elb extends TerraformResource {
    constructor(scope: Construct, id: string, config: ElbConfig);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _connectionDraining?;
    get connectionDraining(): boolean | undefined;
    set connectionDraining(value: boolean | undefined);
    private _connectionDrainingTimeout?;
    get connectionDrainingTimeout(): number | undefined;
    set connectionDrainingTimeout(value: number | undefined);
    private _crossZoneLoadBalancing?;
    get crossZoneLoadBalancing(): boolean | undefined;
    set crossZoneLoadBalancing(value: boolean | undefined);
    get dnsName(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _idleTimeout?;
    get idleTimeout(): number | undefined;
    set idleTimeout(value: number | undefined);
    private _instances?;
    get instances(): string[] | undefined;
    set instances(value: string[] | undefined);
    private _internal?;
    get internal(): boolean | undefined;
    set internal(value: boolean | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _sourceSecurityGroup?;
    get sourceSecurityGroup(): string | undefined;
    set sourceSecurityGroup(value: string | undefined);
    get sourceSecurityGroupId(): string;
    private _subnets?;
    get subnets(): string[] | undefined;
    set subnets(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get zoneId(): string;
    private _accessLogs?;
    get accessLogs(): ElbAccessLogs[] | undefined;
    set accessLogs(value: ElbAccessLogs[] | undefined);
    private _healthCheck?;
    get healthCheck(): ElbHealthCheck[] | undefined;
    set healthCheck(value: ElbHealthCheck[] | undefined);
    private _listener;
    get listener(): ElbListener[];
    set listener(value: ElbListener[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
