import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EmrClusterConfig extends TerraformMetaArguments {
    readonly additionalInfo?: string;
    readonly applications?: string[];
    readonly autoscalingRole?: string;
    readonly configurations?: string;
    readonly configurationsJson?: string;
    readonly coreInstanceCount?: number;
    readonly coreInstanceType?: string;
    readonly customAmiId?: string;
    readonly ebsRootVolumeSize?: number;
    readonly keepJobFlowAliveWhenNoSteps?: boolean;
    readonly logUri?: string;
    readonly masterInstanceType?: string;
    readonly name: string;
    readonly releaseLabel: string;
    readonly scaleDownBehavior?: string;
    readonly securityConfiguration?: string;
    readonly serviceRole: string;
    readonly step?: EmrClusterStep[];
    readonly stepConcurrencyLevel?: number;
    readonly tags?: {
        [key: string]: string;
    };
    readonly terminationProtection?: boolean;
    readonly visibleToAllUsers?: boolean;
    /** bootstrap_action block */
    readonly bootstrapAction?: EmrClusterBootstrapAction[];
    /** core_instance_group block */
    readonly coreInstanceGroup?: EmrClusterCoreInstanceGroup[];
    /** ec2_attributes block */
    readonly ec2Attributes?: EmrClusterEc2Attributes[];
    /** instance_group block */
    readonly instanceGroup?: EmrClusterInstanceGroup[];
    /** kerberos_attributes block */
    readonly kerberosAttributes?: EmrClusterKerberosAttributes[];
    /** master_instance_group block */
    readonly masterInstanceGroup?: EmrClusterMasterInstanceGroup[];
}
export interface EmrClusterStepHadoopJarStep {
    readonly args?: string[];
    readonly jar?: string;
    readonly mainClass?: string;
    readonly properties?: {
        [key: string]: string;
    };
}
export interface EmrClusterStep {
    readonly actionOnFailure?: string;
    readonly hadoopJarStep?: EmrClusterStepHadoopJarStep[];
    readonly name?: string;
}
export interface EmrClusterBootstrapAction {
    readonly args?: string[];
    readonly name: string;
    readonly path: string;
}
export interface EmrClusterCoreInstanceGroupEbsConfig {
    readonly iops?: number;
    readonly size: number;
    readonly type: string;
    readonly volumesPerInstance?: number;
}
export interface EmrClusterCoreInstanceGroup {
    readonly autoscalingPolicy?: string;
    readonly bidPrice?: string;
    readonly instanceCount?: number;
    readonly instanceType: string;
    readonly name?: string;
    /** ebs_config block */
    readonly ebsConfig?: EmrClusterCoreInstanceGroupEbsConfig[];
}
export interface EmrClusterEc2Attributes {
    readonly additionalMasterSecurityGroups?: string;
    readonly additionalSlaveSecurityGroups?: string;
    readonly emrManagedMasterSecurityGroup?: string;
    readonly emrManagedSlaveSecurityGroup?: string;
    readonly instanceProfile: string;
    readonly keyName?: string;
    readonly serviceAccessSecurityGroup?: string;
    readonly subnetId?: string;
}
export interface EmrClusterInstanceGroupEbsConfig {
    readonly iops?: number;
    readonly size: number;
    readonly type: string;
    readonly volumesPerInstance?: number;
}
export interface EmrClusterInstanceGroup {
    readonly autoscalingPolicy?: string;
    readonly bidPrice?: string;
    readonly instanceCount?: number;
    readonly instanceRole: string;
    readonly instanceType: string;
    readonly name?: string;
    /** ebs_config block */
    readonly ebsConfig?: EmrClusterInstanceGroupEbsConfig[];
}
export interface EmrClusterKerberosAttributes {
    readonly adDomainJoinPassword?: string;
    readonly adDomainJoinUser?: string;
    readonly crossRealmTrustPrincipalPassword?: string;
    readonly kdcAdminPassword: string;
    readonly realm: string;
}
export interface EmrClusterMasterInstanceGroupEbsConfig {
    readonly iops?: number;
    readonly size: number;
    readonly type: string;
    readonly volumesPerInstance?: number;
}
export interface EmrClusterMasterInstanceGroup {
    readonly bidPrice?: string;
    readonly instanceCount?: number;
    readonly instanceType: string;
    readonly name?: string;
    /** ebs_config block */
    readonly ebsConfig?: EmrClusterMasterInstanceGroupEbsConfig[];
}
export declare class EmrCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: EmrClusterConfig);
    private _additionalInfo?;
    get additionalInfo(): string | undefined;
    set additionalInfo(value: string | undefined);
    private _applications?;
    get applications(): string[] | undefined;
    set applications(value: string[] | undefined);
    get arn(): string;
    private _autoscalingRole?;
    get autoscalingRole(): string | undefined;
    set autoscalingRole(value: string | undefined);
    get clusterState(): string;
    private _configurations?;
    get configurations(): string | undefined;
    set configurations(value: string | undefined);
    private _configurationsJson?;
    get configurationsJson(): string | undefined;
    set configurationsJson(value: string | undefined);
    private _coreInstanceCount?;
    get coreInstanceCount(): number | undefined;
    set coreInstanceCount(value: number | undefined);
    private _coreInstanceType?;
    get coreInstanceType(): string | undefined;
    set coreInstanceType(value: string | undefined);
    private _customAmiId?;
    get customAmiId(): string | undefined;
    set customAmiId(value: string | undefined);
    private _ebsRootVolumeSize?;
    get ebsRootVolumeSize(): number | undefined;
    set ebsRootVolumeSize(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keepJobFlowAliveWhenNoSteps?;
    get keepJobFlowAliveWhenNoSteps(): boolean | undefined;
    set keepJobFlowAliveWhenNoSteps(value: boolean | undefined);
    private _logUri?;
    get logUri(): string | undefined;
    set logUri(value: string | undefined);
    private _masterInstanceType?;
    get masterInstanceType(): string | undefined;
    set masterInstanceType(value: string | undefined);
    get masterPublicDns(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _releaseLabel;
    get releaseLabel(): string;
    set releaseLabel(value: string);
    private _scaleDownBehavior?;
    get scaleDownBehavior(): string | undefined;
    set scaleDownBehavior(value: string | undefined);
    private _securityConfiguration?;
    get securityConfiguration(): string | undefined;
    set securityConfiguration(value: string | undefined);
    private _serviceRole;
    get serviceRole(): string;
    set serviceRole(value: string);
    private _step?;
    get step(): EmrClusterStep[] | undefined;
    set step(value: EmrClusterStep[] | undefined);
    private _stepConcurrencyLevel?;
    get stepConcurrencyLevel(): number | undefined;
    set stepConcurrencyLevel(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _terminationProtection?;
    get terminationProtection(): boolean | undefined;
    set terminationProtection(value: boolean | undefined);
    private _visibleToAllUsers?;
    get visibleToAllUsers(): boolean | undefined;
    set visibleToAllUsers(value: boolean | undefined);
    private _bootstrapAction?;
    get bootstrapAction(): EmrClusterBootstrapAction[] | undefined;
    set bootstrapAction(value: EmrClusterBootstrapAction[] | undefined);
    private _coreInstanceGroup?;
    get coreInstanceGroup(): EmrClusterCoreInstanceGroup[] | undefined;
    set coreInstanceGroup(value: EmrClusterCoreInstanceGroup[] | undefined);
    private _ec2Attributes?;
    get ec2Attributes(): EmrClusterEc2Attributes[] | undefined;
    set ec2Attributes(value: EmrClusterEc2Attributes[] | undefined);
    private _instanceGroup?;
    get instanceGroup(): EmrClusterInstanceGroup[] | undefined;
    set instanceGroup(value: EmrClusterInstanceGroup[] | undefined);
    private _kerberosAttributes?;
    get kerberosAttributes(): EmrClusterKerberosAttributes[] | undefined;
    set kerberosAttributes(value: EmrClusterKerberosAttributes[] | undefined);
    private _masterInstanceGroup?;
    get masterInstanceGroup(): EmrClusterMasterInstanceGroup[] | undefined;
    set masterInstanceGroup(value: EmrClusterMasterInstanceGroup[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
