"use strict";
// https://www.terraform.io/docs/providers/aws/r/emr_cluster.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrCluster = void 0;
const cdktf_1 = require("cdktf");
// Resource
class EmrCluster extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_emr_cluster',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._additionalInfo = config.additionalInfo;
        this._applications = config.applications;
        this._autoscalingRole = config.autoscalingRole;
        this._configurations = config.configurations;
        this._configurationsJson = config.configurationsJson;
        this._coreInstanceCount = config.coreInstanceCount;
        this._coreInstanceType = config.coreInstanceType;
        this._customAmiId = config.customAmiId;
        this._ebsRootVolumeSize = config.ebsRootVolumeSize;
        this._keepJobFlowAliveWhenNoSteps = config.keepJobFlowAliveWhenNoSteps;
        this._logUri = config.logUri;
        this._masterInstanceType = config.masterInstanceType;
        this._name = config.name;
        this._releaseLabel = config.releaseLabel;
        this._scaleDownBehavior = config.scaleDownBehavior;
        this._securityConfiguration = config.securityConfiguration;
        this._serviceRole = config.serviceRole;
        this._step = config.step;
        this._stepConcurrencyLevel = config.stepConcurrencyLevel;
        this._tags = config.tags;
        this._terminationProtection = config.terminationProtection;
        this._visibleToAllUsers = config.visibleToAllUsers;
        this._bootstrapAction = config.bootstrapAction;
        this._coreInstanceGroup = config.coreInstanceGroup;
        this._ec2Attributes = config.ec2Attributes;
        this._instanceGroup = config.instanceGroup;
        this._kerberosAttributes = config.kerberosAttributes;
        this._masterInstanceGroup = config.masterInstanceGroup;
    }
    get additionalInfo() {
        return this._additionalInfo;
    }
    set additionalInfo(value) {
        this._additionalInfo = value;
    }
    get applications() {
        return this._applications;
    }
    set applications(value) {
        this._applications = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoscalingRole() {
        return this._autoscalingRole;
    }
    set autoscalingRole(value) {
        this._autoscalingRole = value;
    }
    // cluster_state - computed: true, optional: false, required: true
    get clusterState() {
        return this.getStringAttribute('cluster_state');
    }
    get configurations() {
        return this._configurations;
    }
    set configurations(value) {
        this._configurations = value;
    }
    get configurationsJson() {
        return this._configurationsJson;
    }
    set configurationsJson(value) {
        this._configurationsJson = value;
    }
    get coreInstanceCount() {
        var _a;
        return (_a = this._coreInstanceCount) !== null && _a !== void 0 ? _a : this.getNumberAttribute('core_instance_count');
    }
    set coreInstanceCount(value) {
        this._coreInstanceCount = value;
    }
    get coreInstanceType() {
        var _a;
        return (_a = this._coreInstanceType) !== null && _a !== void 0 ? _a : this.getStringAttribute('core_instance_type');
    }
    set coreInstanceType(value) {
        this._coreInstanceType = value;
    }
    get customAmiId() {
        return this._customAmiId;
    }
    set customAmiId(value) {
        this._customAmiId = value;
    }
    get ebsRootVolumeSize() {
        return this._ebsRootVolumeSize;
    }
    set ebsRootVolumeSize(value) {
        this._ebsRootVolumeSize = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get keepJobFlowAliveWhenNoSteps() {
        var _a;
        return (_a = this._keepJobFlowAliveWhenNoSteps) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('keep_job_flow_alive_when_no_steps');
    }
    set keepJobFlowAliveWhenNoSteps(value) {
        this._keepJobFlowAliveWhenNoSteps = value;
    }
    get logUri() {
        return this._logUri;
    }
    set logUri(value) {
        this._logUri = value;
    }
    get masterInstanceType() {
        var _a;
        return (_a = this._masterInstanceType) !== null && _a !== void 0 ? _a : this.getStringAttribute('master_instance_type');
    }
    set masterInstanceType(value) {
        this._masterInstanceType = value;
    }
    // master_public_dns - computed: true, optional: false, required: true
    get masterPublicDns() {
        return this.getStringAttribute('master_public_dns');
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get releaseLabel() {
        return this._releaseLabel;
    }
    set releaseLabel(value) {
        this._releaseLabel = value;
    }
    get scaleDownBehavior() {
        var _a;
        return (_a = this._scaleDownBehavior) !== null && _a !== void 0 ? _a : this.getStringAttribute('scale_down_behavior');
    }
    set scaleDownBehavior(value) {
        this._scaleDownBehavior = value;
    }
    get securityConfiguration() {
        return this._securityConfiguration;
    }
    set securityConfiguration(value) {
        this._securityConfiguration = value;
    }
    get serviceRole() {
        return this._serviceRole;
    }
    set serviceRole(value) {
        this._serviceRole = value;
    }
    get step() {
        return this._step; // Getting the computed value is not yet implemented
    }
    set step(value) {
        this._step = value;
    }
    get stepConcurrencyLevel() {
        return this._stepConcurrencyLevel;
    }
    set stepConcurrencyLevel(value) {
        this._stepConcurrencyLevel = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get terminationProtection() {
        var _a;
        return (_a = this._terminationProtection) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('termination_protection');
    }
    set terminationProtection(value) {
        this._terminationProtection = value;
    }
    get visibleToAllUsers() {
        return this._visibleToAllUsers;
    }
    set visibleToAllUsers(value) {
        this._visibleToAllUsers = value;
    }
    get bootstrapAction() {
        return this._bootstrapAction;
    }
    set bootstrapAction(value) {
        this._bootstrapAction = value;
    }
    get coreInstanceGroup() {
        return this._coreInstanceGroup;
    }
    set coreInstanceGroup(value) {
        this._coreInstanceGroup = value;
    }
    get ec2Attributes() {
        return this._ec2Attributes;
    }
    set ec2Attributes(value) {
        this._ec2Attributes = value;
    }
    get instanceGroup() {
        return this._instanceGroup;
    }
    set instanceGroup(value) {
        this._instanceGroup = value;
    }
    get kerberosAttributes() {
        return this._kerberosAttributes;
    }
    set kerberosAttributes(value) {
        this._kerberosAttributes = value;
    }
    get masterInstanceGroup() {
        return this._masterInstanceGroup;
    }
    set masterInstanceGroup(value) {
        this._masterInstanceGroup = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            additional_info: this._additionalInfo,
            applications: this._applications,
            autoscaling_role: this._autoscalingRole,
            configurations: this._configurations,
            configurations_json: this._configurationsJson,
            core_instance_count: this._coreInstanceCount,
            core_instance_type: this._coreInstanceType,
            custom_ami_id: this._customAmiId,
            ebs_root_volume_size: this._ebsRootVolumeSize,
            keep_job_flow_alive_when_no_steps: this._keepJobFlowAliveWhenNoSteps,
            log_uri: this._logUri,
            master_instance_type: this._masterInstanceType,
            name: this._name,
            release_label: this._releaseLabel,
            scale_down_behavior: this._scaleDownBehavior,
            security_configuration: this._securityConfiguration,
            service_role: this._serviceRole,
            step: this._step,
            step_concurrency_level: this._stepConcurrencyLevel,
            tags: this._tags,
            termination_protection: this._terminationProtection,
            visible_to_all_users: this._visibleToAllUsers,
            bootstrap_action: this._bootstrapAction,
            core_instance_group: this._coreInstanceGroup,
            ec2_attributes: this._ec2Attributes,
            instance_group: this._instanceGroup,
            kerberos_attributes: this._kerberosAttributes,
            master_instance_group: this._masterInstanceGroup,
        };
    }
}
exports.EmrCluster = EmrCluster;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW1yLWNsdXN0ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZW1yLWNsdXN0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLGlFQUFpRTtBQUNqRSwyQ0FBMkM7OztBQXlhM0MsaUNBQTBDO0FBd0gxQyxXQUFXO0FBRVgsTUFBYSxVQUFXLFNBQVEseUJBQWlCO0lBRS9DLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXdCO1FBQ3ZFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsaUJBQWlCO1lBQ3hDLDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsS0FBSzthQUNwQjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsNEJBQTRCLEdBQUcsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBQ3ZFLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsTUFBTSxDQUFDLHFCQUFxQixDQUFDO1FBQzNELElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLHNCQUFzQixHQUFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztRQUMzRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7SUFDekQsQ0FBQztJQVFELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQXlCO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUEyQjtRQUNqRCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBRUQsd0RBQXdEO0lBQ3hELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQXlCO1FBQ2xELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUVELGtFQUFrRTtJQUNsRSxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQXlCO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUF5QjtRQUNyRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLGlCQUFpQjs7UUFDMUIsYUFBTyxJQUFJLENBQUMsa0JBQWtCLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ25GLENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQXlCO1FBQ3BELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsZ0JBQWdCOztRQUN6QixhQUFPLElBQUksQ0FBQyxpQkFBaUIsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDakYsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBeUI7UUFDbkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBeUI7UUFDOUMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQXlCO1FBQ3BELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsRUFBRTs7UUFDWCxhQUFPLElBQUksQ0FBQyxHQUFHLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBeUI7UUFDckMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUlELElBQVcsMkJBQTJCOztRQUNwQyxhQUFPLElBQUksQ0FBQyw0QkFBNEIsbUNBQUksSUFBSSxDQUFDLG1CQUFtQixDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDNUcsQ0FBQztJQUNELElBQVcsMkJBQTJCLENBQUMsS0FBMEI7UUFDL0QsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUF5QjtRQUN6QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVyxrQkFBa0I7O1FBQzNCLGFBQU8sSUFBSSxDQUFDLG1CQUFtQixtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUNyRixDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUF5QjtRQUNyRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFFRCxzRUFBc0U7SUFDdEUsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7O1FBQzFCLGFBQU8sSUFBSSxDQUFDLGtCQUFrQixtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUNuRixDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUF5QjtRQUNwRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBQ0QsSUFBVyxxQkFBcUIsQ0FBQyxLQUF5QjtRQUN4RCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxvREFBb0Q7SUFDekUsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQW1DO1FBQ2pELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUF5QjtRQUN2RCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQTRDO1FBQzFELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLHFCQUFxQjs7UUFDOUIsYUFBTyxJQUFJLENBQUMsc0JBQXNCLG1DQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNGLENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQTBCO1FBQ3pELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQTBCO1FBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBOEM7UUFDdkUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBZ0Q7UUFDM0UsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBNEM7UUFDbkUsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQTRDO1FBQ25FLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFpRDtRQUM3RSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFrRDtRQUMvRSxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFTCxvQkFBb0I7UUFDekIsT0FBTztZQUNMLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxZQUFZLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDaEMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDcEMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzVDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDMUMsYUFBYSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQ2hDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDN0MsaUNBQWlDLEVBQUUsSUFBSSxDQUFDLDRCQUE0QjtZQUNwRSxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM5QyxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDNUMsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLHNCQUFzQjtZQUNuRCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLHNCQUFzQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7WUFDbEQsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLHNCQUFzQixFQUFFLElBQUksQ0FBQyxzQkFBc0I7WUFDbkQsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUM3QyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDNUMsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLHFCQUFxQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7U0FDakQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQTNXRCxnQ0EyV0MiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3IvZW1yX2NsdXN0ZXIuaHRtbFxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG4vKlxue1xuICBcInZlcnNpb25cIjogMCxcbiAgXCJibG9ja1wiOiB7XG4gICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgIFwiYWRkaXRpb25hbF9pbmZvXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYXBwbGljYXRpb25zXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcInNldFwiLFxuICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgXSxcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJhcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJhdXRvc2NhbGluZ19yb2xlXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiY2x1c3Rlcl9zdGF0ZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNvbmZpZ3VyYXRpb25zXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiY29uZmlndXJhdGlvbnNfanNvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNvcmVfaW5zdGFuY2VfY291bnRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNvcmVfaW5zdGFuY2VfdHlwZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiY3VzdG9tX2FtaV9pZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImVic19yb290X3ZvbHVtZV9zaXplXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImtlZXBfam9iX2Zsb3dfYWxpdmVfd2hlbl9ub19zdGVwc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImxvZ191cmlcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJtYXN0ZXJfaW5zdGFuY2VfdHlwZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwibWFzdGVyX3B1YmxpY19kbnNcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVsZWFzZV9sYWJlbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInNjYWxlX2Rvd25fYmVoYXZpb3JcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInNlY3VyaXR5X2NvbmZpZ3VyYXRpb25cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJzZXJ2aWNlX3JvbGVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJzdGVwXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICBbXG4gICAgICAgICAgICBcIm9iamVjdFwiLFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBcImFjdGlvbl9vbl9mYWlsdXJlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiaGFkb29wX2phcl9zdGVwXCI6IFtcbiAgICAgICAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICAgICAgICBbXG4gICAgICAgICAgICAgICAgICBcIm9iamVjdFwiLFxuICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICBcImFyZ3NcIjogW1xuICAgICAgICAgICAgICAgICAgICAgIFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICAgICAgXCJqYXJcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJtYWluX2NsYXNzXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicHJvcGVydGllc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBdXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwibmFtZVwiOiBcInN0cmluZ1wiXG4gICAgICAgICAgICB9XG4gICAgICAgICAgXVxuICAgICAgICBdLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwic3RlcF9jb25jdXJyZW5jeV9sZXZlbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInRhZ3NcIjoge1xuICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgIFwibWFwXCIsXG4gICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICBdLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInRlcm1pbmF0aW9uX3Byb3RlY3Rpb25cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ2aXNpYmxlX3RvX2FsbF91c2Vyc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9XG4gICAgfSxcbiAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgIFwiYm9vdHN0cmFwX2FjdGlvblwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJhcmdzXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInBhdGhcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJjb3JlX2luc3RhbmNlX2dyb3VwXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImF1dG9zY2FsaW5nX3BvbGljeVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImJpZF9wcmljZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaW5zdGFuY2VfY291bnRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJpbnN0YW5jZV90eXBlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9LFxuICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgXCJlYnNfY29uZmlnXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJzZXRcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiaW9wc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInNpemVcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwidm9sdW1lc19wZXJfaW5zdGFuY2VcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9LFxuICAgICAgXCJlYzJfYXR0cmlidXRlc1wiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJhZGRpdGlvbmFsX21hc3Rlcl9zZWN1cml0eV9ncm91cHNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJhZGRpdGlvbmFsX3NsYXZlX3NlY3VyaXR5X2dyb3Vwc1wiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImVtcl9tYW5hZ2VkX21hc3Rlcl9zZWN1cml0eV9ncm91cFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiZW1yX21hbmFnZWRfc2xhdmVfc2VjdXJpdHlfZ3JvdXBcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImluc3RhbmNlX3Byb2ZpbGVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJrZXlfbmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInNlcnZpY2VfYWNjZXNzX3NlY3VyaXR5X2dyb3VwXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzdWJuZXRfaWRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9LFxuICAgICAgXCJpbnN0YW5jZV9ncm91cFwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImF1dG9zY2FsaW5nX3BvbGljeVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImJpZF9wcmljZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaW5zdGFuY2VfY291bnRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJpbnN0YW5jZV9yb2xlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaW5zdGFuY2VfdHlwZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIm5hbWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSxcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwiZWJzX2NvbmZpZ1wiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImlvcHNcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJzaXplXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInZvbHVtZXNfcGVyX2luc3RhbmNlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSxcbiAgICAgIFwia2VyYmVyb3NfYXR0cmlidXRlc1wiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJhZF9kb21haW5fam9pbl9wYXNzd29yZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgIFwic2Vuc2l0aXZlXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImFkX2RvbWFpbl9qb2luX3VzZXJcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJjcm9zc19yZWFsbV90cnVzdF9wcmluY2lwYWxfcGFzc3dvcmRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICAgICAgICBcInNlbnNpdGl2ZVwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJrZGNfYWRtaW5fcGFzc3dvcmRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlLFxuICAgICAgICAgICAgICBcInNlbnNpdGl2ZVwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJyZWFsbVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcIm1hc3Rlcl9pbnN0YW5jZV9ncm91cFwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJiaWRfcHJpY2VcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJpZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImluc3RhbmNlX2NvdW50XCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaW5zdGFuY2VfdHlwZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIm5hbWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSxcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwiZWJzX2NvbmZpZ1wiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImlvcHNcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJzaXplXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInZvbHVtZXNfcGVyX2luc3RhbmNlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgfVxuICAgIH1cbiAgfVxufVxuKi9cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgVGVycmFmb3JtUmVzb3VyY2UgfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIH0gZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgRW1yQ2x1c3RlckNvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBhZGRpdGlvbmFsSW5mbz86IHN0cmluZztcbiAgcmVhZG9ubHkgYXBwbGljYXRpb25zPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGF1dG9zY2FsaW5nUm9sZT86IHN0cmluZztcbiAgcmVhZG9ubHkgY29uZmlndXJhdGlvbnM/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25zSnNvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgY29yZUluc3RhbmNlQ291bnQ/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGNvcmVJbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGN1c3RvbUFtaUlkPzogc3RyaW5nO1xuICByZWFkb25seSBlYnNSb290Vm9sdW1lU2l6ZT86IG51bWJlcjtcbiAgcmVhZG9ubHkga2VlcEpvYkZsb3dBbGl2ZVdoZW5Ob1N0ZXBzPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgbG9nVXJpPzogc3RyaW5nO1xuICByZWFkb25seSBtYXN0ZXJJbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgcmVsZWFzZUxhYmVsOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNjYWxlRG93bkJlaGF2aW9yPzogc3RyaW5nO1xuICByZWFkb25seSBzZWN1cml0eUNvbmZpZ3VyYXRpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VSb2xlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN0ZXA/OiBFbXJDbHVzdGVyU3RlcFtdO1xuICByZWFkb25seSBzdGVwQ29uY3VycmVuY3lMZXZlbD86IG51bWJlcjtcbiAgcmVhZG9ubHkgdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIHJlYWRvbmx5IHRlcm1pbmF0aW9uUHJvdGVjdGlvbj86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHZpc2libGVUb0FsbFVzZXJzPzogYm9vbGVhbjtcbiAgLyoqIGJvb3RzdHJhcF9hY3Rpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgYm9vdHN0cmFwQWN0aW9uPzogRW1yQ2x1c3RlckJvb3RzdHJhcEFjdGlvbltdO1xuICAvKiogY29yZV9pbnN0YW5jZV9ncm91cCBibG9jayAqL1xuICByZWFkb25seSBjb3JlSW5zdGFuY2VHcm91cD86IEVtckNsdXN0ZXJDb3JlSW5zdGFuY2VHcm91cFtdO1xuICAvKiogZWMyX2F0dHJpYnV0ZXMgYmxvY2sgKi9cbiAgcmVhZG9ubHkgZWMyQXR0cmlidXRlcz86IEVtckNsdXN0ZXJFYzJBdHRyaWJ1dGVzW107XG4gIC8qKiBpbnN0YW5jZV9ncm91cCBibG9jayAqL1xuICByZWFkb25seSBpbnN0YW5jZUdyb3VwPzogRW1yQ2x1c3Rlckluc3RhbmNlR3JvdXBbXTtcbiAgLyoqIGtlcmJlcm9zX2F0dHJpYnV0ZXMgYmxvY2sgKi9cbiAgcmVhZG9ubHkga2VyYmVyb3NBdHRyaWJ1dGVzPzogRW1yQ2x1c3RlcktlcmJlcm9zQXR0cmlidXRlc1tdO1xuICAvKiogbWFzdGVyX2luc3RhbmNlX2dyb3VwIGJsb2NrICovXG4gIHJlYWRvbmx5IG1hc3Rlckluc3RhbmNlR3JvdXA/OiBFbXJDbHVzdGVyTWFzdGVySW5zdGFuY2VHcm91cFtdO1xufVxuZXhwb3J0IGludGVyZmFjZSBFbXJDbHVzdGVyU3RlcEhhZG9vcEphclN0ZXAge1xuICByZWFkb25seSBhcmdzPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGphcj86IHN0cmluZztcbiAgcmVhZG9ubHkgbWFpbkNsYXNzPzogc3RyaW5nO1xuICByZWFkb25seSBwcm9wZXJ0aWVzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgRW1yQ2x1c3RlclN0ZXAge1xuICByZWFkb25seSBhY3Rpb25PbkZhaWx1cmU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGhhZG9vcEphclN0ZXA/OiBFbXJDbHVzdGVyU3RlcEhhZG9vcEphclN0ZXBbXTtcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgRW1yQ2x1c3RlckJvb3RzdHJhcEFjdGlvbiB7XG4gIHJlYWRvbmx5IGFyZ3M/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEVtckNsdXN0ZXJDb3JlSW5zdGFuY2VHcm91cEVic0NvbmZpZyB7XG4gIHJlYWRvbmx5IGlvcHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHNpemU6IG51bWJlcjtcbiAgcmVhZG9ubHkgdHlwZTogc3RyaW5nO1xuICByZWFkb25seSB2b2x1bWVzUGVySW5zdGFuY2U/OiBudW1iZXI7XG59XG5leHBvcnQgaW50ZXJmYWNlIEVtckNsdXN0ZXJDb3JlSW5zdGFuY2VHcm91cCB7XG4gIHJlYWRvbmx5IGF1dG9zY2FsaW5nUG9saWN5Pzogc3RyaW5nO1xuICByZWFkb25seSBiaWRQcmljZT86IHN0cmluZztcbiAgcmVhZG9ubHkgaW5zdGFuY2VDb3VudD86IG51bWJlcjtcbiAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gIC8qKiBlYnNfY29uZmlnIGJsb2NrICovXG4gIHJlYWRvbmx5IGVic0NvbmZpZz86IEVtckNsdXN0ZXJDb3JlSW5zdGFuY2VHcm91cEVic0NvbmZpZ1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBFbXJDbHVzdGVyRWMyQXR0cmlidXRlcyB7XG4gIHJlYWRvbmx5IGFkZGl0aW9uYWxNYXN0ZXJTZWN1cml0eUdyb3Vwcz86IHN0cmluZztcbiAgcmVhZG9ubHkgYWRkaXRpb25hbFNsYXZlU2VjdXJpdHlHcm91cHM/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGVtck1hbmFnZWRNYXN0ZXJTZWN1cml0eUdyb3VwPzogc3RyaW5nO1xuICByZWFkb25seSBlbXJNYW5hZ2VkU2xhdmVTZWN1cml0eUdyb3VwPzogc3RyaW5nO1xuICByZWFkb25seSBpbnN0YW5jZVByb2ZpbGU6IHN0cmluZztcbiAgcmVhZG9ubHkga2V5TmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgc2VydmljZUFjY2Vzc1NlY3VyaXR5R3JvdXA/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN1Ym5ldElkPzogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBFbXJDbHVzdGVySW5zdGFuY2VHcm91cEVic0NvbmZpZyB7XG4gIHJlYWRvbmx5IGlvcHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHNpemU6IG51bWJlcjtcbiAgcmVhZG9ubHkgdHlwZTogc3RyaW5nO1xuICByZWFkb25seSB2b2x1bWVzUGVySW5zdGFuY2U/OiBudW1iZXI7XG59XG5leHBvcnQgaW50ZXJmYWNlIEVtckNsdXN0ZXJJbnN0YW5jZUdyb3VwIHtcbiAgcmVhZG9ubHkgYXV0b3NjYWxpbmdQb2xpY3k/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGJpZFByaWNlPzogc3RyaW5nO1xuICByZWFkb25seSBpbnN0YW5jZUNvdW50PzogbnVtYmVyO1xuICByZWFkb25seSBpbnN0YW5jZVJvbGU6IHN0cmluZztcbiAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gIC8qKiBlYnNfY29uZmlnIGJsb2NrICovXG4gIHJlYWRvbmx5IGVic0NvbmZpZz86IEVtckNsdXN0ZXJJbnN0YW5jZUdyb3VwRWJzQ29uZmlnW107XG59XG5leHBvcnQgaW50ZXJmYWNlIEVtckNsdXN0ZXJLZXJiZXJvc0F0dHJpYnV0ZXMge1xuICByZWFkb25seSBhZERvbWFpbkpvaW5QYXNzd29yZD86IHN0cmluZztcbiAgcmVhZG9ubHkgYWREb21haW5Kb2luVXNlcj86IHN0cmluZztcbiAgcmVhZG9ubHkgY3Jvc3NSZWFsbVRydXN0UHJpbmNpcGFsUGFzc3dvcmQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGtkY0FkbWluUGFzc3dvcmQ6IHN0cmluZztcbiAgcmVhZG9ubHkgcmVhbG06IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgRW1yQ2x1c3Rlck1hc3Rlckluc3RhbmNlR3JvdXBFYnNDb25maWcge1xuICByZWFkb25seSBpb3BzPzogbnVtYmVyO1xuICByZWFkb25seSBzaXplOiBudW1iZXI7XG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgcmVhZG9ubHkgdm9sdW1lc1Blckluc3RhbmNlPzogbnVtYmVyO1xufVxuZXhwb3J0IGludGVyZmFjZSBFbXJDbHVzdGVyTWFzdGVySW5zdGFuY2VHcm91cCB7XG4gIHJlYWRvbmx5IGJpZFByaWNlPzogc3RyaW5nO1xuICByZWFkb25seSBpbnN0YW5jZUNvdW50PzogbnVtYmVyO1xuICByZWFkb25seSBpbnN0YW5jZVR5cGU6IHN0cmluZztcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbiAgLyoqIGVic19jb25maWcgYmxvY2sgKi9cbiAgcmVhZG9ubHkgZWJzQ29uZmlnPzogRW1yQ2x1c3Rlck1hc3Rlckluc3RhbmNlR3JvdXBFYnNDb25maWdbXTtcbn1cblxuLy8gUmVzb3VyY2VcblxuZXhwb3J0IGNsYXNzIEVtckNsdXN0ZXIgZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBFbXJDbHVzdGVyQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfZW1yX2NsdXN0ZXInLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnYXdzJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlXG4gICAgfSk7XG4gICAgdGhpcy5fYWRkaXRpb25hbEluZm8gPSBjb25maWcuYWRkaXRpb25hbEluZm87XG4gICAgdGhpcy5fYXBwbGljYXRpb25zID0gY29uZmlnLmFwcGxpY2F0aW9ucztcbiAgICB0aGlzLl9hdXRvc2NhbGluZ1JvbGUgPSBjb25maWcuYXV0b3NjYWxpbmdSb2xlO1xuICAgIHRoaXMuX2NvbmZpZ3VyYXRpb25zID0gY29uZmlnLmNvbmZpZ3VyYXRpb25zO1xuICAgIHRoaXMuX2NvbmZpZ3VyYXRpb25zSnNvbiA9IGNvbmZpZy5jb25maWd1cmF0aW9uc0pzb247XG4gICAgdGhpcy5fY29yZUluc3RhbmNlQ291bnQgPSBjb25maWcuY29yZUluc3RhbmNlQ291bnQ7XG4gICAgdGhpcy5fY29yZUluc3RhbmNlVHlwZSA9IGNvbmZpZy5jb3JlSW5zdGFuY2VUeXBlO1xuICAgIHRoaXMuX2N1c3RvbUFtaUlkID0gY29uZmlnLmN1c3RvbUFtaUlkO1xuICAgIHRoaXMuX2Vic1Jvb3RWb2x1bWVTaXplID0gY29uZmlnLmVic1Jvb3RWb2x1bWVTaXplO1xuICAgIHRoaXMuX2tlZXBKb2JGbG93QWxpdmVXaGVuTm9TdGVwcyA9IGNvbmZpZy5rZWVwSm9iRmxvd0FsaXZlV2hlbk5vU3RlcHM7XG4gICAgdGhpcy5fbG9nVXJpID0gY29uZmlnLmxvZ1VyaTtcbiAgICB0aGlzLl9tYXN0ZXJJbnN0YW5jZVR5cGUgPSBjb25maWcubWFzdGVySW5zdGFuY2VUeXBlO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9yZWxlYXNlTGFiZWwgPSBjb25maWcucmVsZWFzZUxhYmVsO1xuICAgIHRoaXMuX3NjYWxlRG93bkJlaGF2aW9yID0gY29uZmlnLnNjYWxlRG93bkJlaGF2aW9yO1xuICAgIHRoaXMuX3NlY3VyaXR5Q29uZmlndXJhdGlvbiA9IGNvbmZpZy5zZWN1cml0eUNvbmZpZ3VyYXRpb247XG4gICAgdGhpcy5fc2VydmljZVJvbGUgPSBjb25maWcuc2VydmljZVJvbGU7XG4gICAgdGhpcy5fc3RlcCA9IGNvbmZpZy5zdGVwO1xuICAgIHRoaXMuX3N0ZXBDb25jdXJyZW5jeUxldmVsID0gY29uZmlnLnN0ZXBDb25jdXJyZW5jeUxldmVsO1xuICAgIHRoaXMuX3RhZ3MgPSBjb25maWcudGFncztcbiAgICB0aGlzLl90ZXJtaW5hdGlvblByb3RlY3Rpb24gPSBjb25maWcudGVybWluYXRpb25Qcm90ZWN0aW9uO1xuICAgIHRoaXMuX3Zpc2libGVUb0FsbFVzZXJzID0gY29uZmlnLnZpc2libGVUb0FsbFVzZXJzO1xuICAgIHRoaXMuX2Jvb3RzdHJhcEFjdGlvbiA9IGNvbmZpZy5ib290c3RyYXBBY3Rpb247XG4gICAgdGhpcy5fY29yZUluc3RhbmNlR3JvdXAgPSBjb25maWcuY29yZUluc3RhbmNlR3JvdXA7XG4gICAgdGhpcy5fZWMyQXR0cmlidXRlcyA9IGNvbmZpZy5lYzJBdHRyaWJ1dGVzO1xuICAgIHRoaXMuX2luc3RhbmNlR3JvdXAgPSBjb25maWcuaW5zdGFuY2VHcm91cDtcbiAgICB0aGlzLl9rZXJiZXJvc0F0dHJpYnV0ZXMgPSBjb25maWcua2VyYmVyb3NBdHRyaWJ1dGVzO1xuICAgIHRoaXMuX21hc3Rlckluc3RhbmNlR3JvdXAgPSBjb25maWcubWFzdGVySW5zdGFuY2VHcm91cDtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWRkaXRpb25hbF9pbmZvIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FkZGl0aW9uYWxJbmZvPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGFkZGl0aW9uYWxJbmZvKCkge1xuICAgIHJldHVybiB0aGlzLl9hZGRpdGlvbmFsSW5mbztcbiAgfVxuICBwdWJsaWMgc2V0IGFkZGl0aW9uYWxJbmZvKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hZGRpdGlvbmFsSW5mbyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYXBwbGljYXRpb25zIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FwcGxpY2F0aW9ucz86IHN0cmluZ1tdO1xuICBwdWJsaWMgZ2V0IGFwcGxpY2F0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy5fYXBwbGljYXRpb25zO1xuICB9XG4gIHB1YmxpYyBzZXQgYXBwbGljYXRpb25zKHZhbHVlOiBzdHJpbmdbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2FwcGxpY2F0aW9ucyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYXJuIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBhcm4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdhcm4nKTtcbiAgfVxuXG4gIC8vIGF1dG9zY2FsaW5nX3JvbGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXV0b3NjYWxpbmdSb2xlPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGF1dG9zY2FsaW5nUm9sZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXV0b3NjYWxpbmdSb2xlO1xuICB9XG4gIHB1YmxpYyBzZXQgYXV0b3NjYWxpbmdSb2xlKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hdXRvc2NhbGluZ1JvbGUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGNsdXN0ZXJfc3RhdGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IGNsdXN0ZXJTdGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NsdXN0ZXJfc3RhdGUnKTtcbiAgfVxuXG4gIC8vIGNvbmZpZ3VyYXRpb25zIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbmZpZ3VyYXRpb25zPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGNvbmZpZ3VyYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLl9jb25maWd1cmF0aW9ucztcbiAgfVxuICBwdWJsaWMgc2V0IGNvbmZpZ3VyYXRpb25zKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jb25maWd1cmF0aW9ucyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY29uZmlndXJhdGlvbnNfanNvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb25maWd1cmF0aW9uc0pzb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgY29uZmlndXJhdGlvbnNKc29uKCkge1xuICAgIHJldHVybiB0aGlzLl9jb25maWd1cmF0aW9uc0pzb247XG4gIH1cbiAgcHVibGljIHNldCBjb25maWd1cmF0aW9uc0pzb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NvbmZpZ3VyYXRpb25zSnNvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY29yZV9pbnN0YW5jZV9jb3VudCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvcmVJbnN0YW5jZUNvdW50PzogbnVtYmVyO1xuICBwdWJsaWMgZ2V0IGNvcmVJbnN0YW5jZUNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLl9jb3JlSW5zdGFuY2VDb3VudCA/PyB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY29yZV9pbnN0YW5jZV9jb3VudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgY29yZUluc3RhbmNlQ291bnQodmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NvcmVJbnN0YW5jZUNvdW50ID0gdmFsdWU7XG4gIH1cblxuICAvLyBjb3JlX2luc3RhbmNlX3R5cGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb3JlSW5zdGFuY2VUeXBlPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGNvcmVJbnN0YW5jZVR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvcmVJbnN0YW5jZVR5cGUgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NvcmVfaW5zdGFuY2VfdHlwZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY29yZUluc3RhbmNlVHlwZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY29yZUluc3RhbmNlVHlwZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY3VzdG9tX2FtaV9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jdXN0b21BbWlJZD86IHN0cmluZztcbiAgcHVibGljIGdldCBjdXN0b21BbWlJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3VzdG9tQW1pSWQ7XG4gIH1cbiAgcHVibGljIHNldCBjdXN0b21BbWlJZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY3VzdG9tQW1pSWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGVic19yb290X3ZvbHVtZV9zaXplIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Vic1Jvb3RWb2x1bWVTaXplPzogbnVtYmVyO1xuICBwdWJsaWMgZ2V0IGVic1Jvb3RWb2x1bWVTaXplKCkge1xuICAgIHJldHVybiB0aGlzLl9lYnNSb290Vm9sdW1lU2l6ZTtcbiAgfVxuICBwdWJsaWMgc2V0IGVic1Jvb3RWb2x1bWVTaXplKHZhbHVlOiBudW1iZXIgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9lYnNSb290Vm9sdW1lU2l6ZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZztcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGtlZXBfam9iX2Zsb3dfYWxpdmVfd2hlbl9ub19zdGVwcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2tlZXBKb2JGbG93QWxpdmVXaGVuTm9TdGVwcz86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQga2VlcEpvYkZsb3dBbGl2ZVdoZW5Ob1N0ZXBzKCkge1xuICAgIHJldHVybiB0aGlzLl9rZWVwSm9iRmxvd0FsaXZlV2hlbk5vU3RlcHMgPz8gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdrZWVwX2pvYl9mbG93X2FsaXZlX3doZW5fbm9fc3RlcHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGtlZXBKb2JGbG93QWxpdmVXaGVuTm9TdGVwcyh2YWx1ZTogYm9vbGVhbiB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2tlZXBKb2JGbG93QWxpdmVXaGVuTm9TdGVwcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbG9nX3VyaSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9sb2dVcmk/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgbG9nVXJpKCkge1xuICAgIHJldHVybiB0aGlzLl9sb2dVcmk7XG4gIH1cbiAgcHVibGljIHNldCBsb2dVcmkodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2xvZ1VyaSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbWFzdGVyX2luc3RhbmNlX3R5cGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYXN0ZXJJbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgbWFzdGVySW5zdGFuY2VUeXBlKCkge1xuICAgIHJldHVybiB0aGlzLl9tYXN0ZXJJbnN0YW5jZVR5cGUgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21hc3Rlcl9pbnN0YW5jZV90eXBlJyk7XG4gIH1cbiAgcHVibGljIHNldCBtYXN0ZXJJbnN0YW5jZVR5cGUodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX21hc3Rlckluc3RhbmNlVHlwZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbWFzdGVyX3B1YmxpY19kbnMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IG1hc3RlclB1YmxpY0RucygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21hc3Rlcl9wdWJsaWNfZG5zJyk7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU6IHN0cmluZztcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcmVsZWFzZV9sYWJlbCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9yZWxlYXNlTGFiZWw6IHN0cmluZztcbiAgcHVibGljIGdldCByZWxlYXNlTGFiZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlbGVhc2VMYWJlbDtcbiAgfVxuICBwdWJsaWMgc2V0IHJlbGVhc2VMYWJlbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVsZWFzZUxhYmVsID0gdmFsdWU7XG4gIH1cblxuICAvLyBzY2FsZV9kb3duX2JlaGF2aW9yIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2NhbGVEb3duQmVoYXZpb3I/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgc2NhbGVEb3duQmVoYXZpb3IoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NjYWxlRG93bkJlaGF2aW9yID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzY2FsZV9kb3duX2JlaGF2aW9yJyk7XG4gIH1cbiAgcHVibGljIHNldCBzY2FsZURvd25CZWhhdmlvcih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fc2NhbGVEb3duQmVoYXZpb3IgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHNlY3VyaXR5X2NvbmZpZ3VyYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2VjdXJpdHlDb25maWd1cmF0aW9uPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHNlY3VyaXR5Q29uZmlndXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VjdXJpdHlDb25maWd1cmF0aW9uO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VjdXJpdHlDb25maWd1cmF0aW9uKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zZWN1cml0eUNvbmZpZ3VyYXRpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHNlcnZpY2Vfcm9sZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9zZXJ2aWNlUm9sZTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHNlcnZpY2VSb2xlKCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2aWNlUm9sZTtcbiAgfVxuICBwdWJsaWMgc2V0IHNlcnZpY2VSb2xlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zZXJ2aWNlUm9sZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc3RlcCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0ZXA/OiBFbXJDbHVzdGVyU3RlcFtdXG4gIHB1YmxpYyBnZXQgc3RlcCgpOiBFbXJDbHVzdGVyU3RlcFtdIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fc3RlcDsgLy8gR2V0dGluZyB0aGUgY29tcHV0ZWQgdmFsdWUgaXMgbm90IHlldCBpbXBsZW1lbnRlZFxuICB9XG4gIHB1YmxpYyBzZXQgc3RlcCh2YWx1ZTogRW1yQ2x1c3RlclN0ZXBbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3N0ZXAgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHN0ZXBfY29uY3VycmVuY3lfbGV2ZWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3RlcENvbmN1cnJlbmN5TGV2ZWw/OiBudW1iZXI7XG4gIHB1YmxpYyBnZXQgc3RlcENvbmN1cnJlbmN5TGV2ZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N0ZXBDb25jdXJyZW5jeUxldmVsO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RlcENvbmN1cnJlbmN5TGV2ZWwodmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3N0ZXBDb25jdXJyZW5jeUxldmVsID0gdmFsdWU7XG4gIH1cblxuICAvLyB0YWdzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICBwdWJsaWMgZ2V0IHRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RhZ3M7XG4gIH1cbiAgcHVibGljIHNldCB0YWdzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9IHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fdGFncyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gdGVybWluYXRpb25fcHJvdGVjdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Rlcm1pbmF0aW9uUHJvdGVjdGlvbj86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgdGVybWluYXRpb25Qcm90ZWN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLl90ZXJtaW5hdGlvblByb3RlY3Rpb24gPz8gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCd0ZXJtaW5hdGlvbl9wcm90ZWN0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCB0ZXJtaW5hdGlvblByb3RlY3Rpb24odmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl90ZXJtaW5hdGlvblByb3RlY3Rpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHZpc2libGVfdG9fYWxsX3VzZXJzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Zpc2libGVUb0FsbFVzZXJzPzogYm9vbGVhbjtcbiAgcHVibGljIGdldCB2aXNpYmxlVG9BbGxVc2VycygpIHtcbiAgICByZXR1cm4gdGhpcy5fdmlzaWJsZVRvQWxsVXNlcnM7XG4gIH1cbiAgcHVibGljIHNldCB2aXNpYmxlVG9BbGxVc2Vycyh2YWx1ZTogYm9vbGVhbiB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3Zpc2libGVUb0FsbFVzZXJzID0gdmFsdWU7XG4gIH1cblxuICAvLyBib290c3RyYXBfYWN0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jvb3RzdHJhcEFjdGlvbj86IEVtckNsdXN0ZXJCb290c3RyYXBBY3Rpb25bXTtcbiAgcHVibGljIGdldCBib290c3RyYXBBY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jvb3RzdHJhcEFjdGlvbjtcbiAgfVxuICBwdWJsaWMgc2V0IGJvb3RzdHJhcEFjdGlvbih2YWx1ZTogRW1yQ2x1c3RlckJvb3RzdHJhcEFjdGlvbltdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYm9vdHN0cmFwQWN0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBjb3JlX2luc3RhbmNlX2dyb3VwIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvcmVJbnN0YW5jZUdyb3VwPzogRW1yQ2x1c3RlckNvcmVJbnN0YW5jZUdyb3VwW107XG4gIHB1YmxpYyBnZXQgY29yZUluc3RhbmNlR3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvcmVJbnN0YW5jZUdyb3VwO1xuICB9XG4gIHB1YmxpYyBzZXQgY29yZUluc3RhbmNlR3JvdXAodmFsdWU6IEVtckNsdXN0ZXJDb3JlSW5zdGFuY2VHcm91cFtdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY29yZUluc3RhbmNlR3JvdXAgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGVjMl9hdHRyaWJ1dGVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VjMkF0dHJpYnV0ZXM/OiBFbXJDbHVzdGVyRWMyQXR0cmlidXRlc1tdO1xuICBwdWJsaWMgZ2V0IGVjMkF0dHJpYnV0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VjMkF0dHJpYnV0ZXM7XG4gIH1cbiAgcHVibGljIHNldCBlYzJBdHRyaWJ1dGVzKHZhbHVlOiBFbXJDbHVzdGVyRWMyQXR0cmlidXRlc1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZWMyQXR0cmlidXRlcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gaW5zdGFuY2VfZ3JvdXAgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5zdGFuY2VHcm91cD86IEVtckNsdXN0ZXJJbnN0YW5jZUdyb3VwW107XG4gIHB1YmxpYyBnZXQgaW5zdGFuY2VHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy5faW5zdGFuY2VHcm91cDtcbiAgfVxuICBwdWJsaWMgc2V0IGluc3RhbmNlR3JvdXAodmFsdWU6IEVtckNsdXN0ZXJJbnN0YW5jZUdyb3VwW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pbnN0YW5jZUdyb3VwID0gdmFsdWU7XG4gIH1cblxuICAvLyBrZXJiZXJvc19hdHRyaWJ1dGVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2tlcmJlcm9zQXR0cmlidXRlcz86IEVtckNsdXN0ZXJLZXJiZXJvc0F0dHJpYnV0ZXNbXTtcbiAgcHVibGljIGdldCBrZXJiZXJvc0F0dHJpYnV0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2tlcmJlcm9zQXR0cmlidXRlcztcbiAgfVxuICBwdWJsaWMgc2V0IGtlcmJlcm9zQXR0cmlidXRlcyh2YWx1ZTogRW1yQ2x1c3RlcktlcmJlcm9zQXR0cmlidXRlc1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fa2VyYmVyb3NBdHRyaWJ1dGVzID0gdmFsdWU7XG4gIH1cblxuICAvLyBtYXN0ZXJfaW5zdGFuY2VfZ3JvdXAgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWFzdGVySW5zdGFuY2VHcm91cD86IEVtckNsdXN0ZXJNYXN0ZXJJbnN0YW5jZUdyb3VwW107XG4gIHB1YmxpYyBnZXQgbWFzdGVySW5zdGFuY2VHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWFzdGVySW5zdGFuY2VHcm91cDtcbiAgfVxuICBwdWJsaWMgc2V0IG1hc3Rlckluc3RhbmNlR3JvdXAodmFsdWU6IEVtckNsdXN0ZXJNYXN0ZXJJbnN0YW5jZUdyb3VwW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9tYXN0ZXJJbnN0YW5jZUdyb3VwID0gdmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHB1YmxpYyBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFkZGl0aW9uYWxfaW5mbzogdGhpcy5fYWRkaXRpb25hbEluZm8sXG4gICAgICBhcHBsaWNhdGlvbnM6IHRoaXMuX2FwcGxpY2F0aW9ucyxcbiAgICAgIGF1dG9zY2FsaW5nX3JvbGU6IHRoaXMuX2F1dG9zY2FsaW5nUm9sZSxcbiAgICAgIGNvbmZpZ3VyYXRpb25zOiB0aGlzLl9jb25maWd1cmF0aW9ucyxcbiAgICAgIGNvbmZpZ3VyYXRpb25zX2pzb246IHRoaXMuX2NvbmZpZ3VyYXRpb25zSnNvbixcbiAgICAgIGNvcmVfaW5zdGFuY2VfY291bnQ6IHRoaXMuX2NvcmVJbnN0YW5jZUNvdW50LFxuICAgICAgY29yZV9pbnN0YW5jZV90eXBlOiB0aGlzLl9jb3JlSW5zdGFuY2VUeXBlLFxuICAgICAgY3VzdG9tX2FtaV9pZDogdGhpcy5fY3VzdG9tQW1pSWQsXG4gICAgICBlYnNfcm9vdF92b2x1bWVfc2l6ZTogdGhpcy5fZWJzUm9vdFZvbHVtZVNpemUsXG4gICAgICBrZWVwX2pvYl9mbG93X2FsaXZlX3doZW5fbm9fc3RlcHM6IHRoaXMuX2tlZXBKb2JGbG93QWxpdmVXaGVuTm9TdGVwcyxcbiAgICAgIGxvZ191cmk6IHRoaXMuX2xvZ1VyaSxcbiAgICAgIG1hc3Rlcl9pbnN0YW5jZV90eXBlOiB0aGlzLl9tYXN0ZXJJbnN0YW5jZVR5cGUsXG4gICAgICBuYW1lOiB0aGlzLl9uYW1lLFxuICAgICAgcmVsZWFzZV9sYWJlbDogdGhpcy5fcmVsZWFzZUxhYmVsLFxuICAgICAgc2NhbGVfZG93bl9iZWhhdmlvcjogdGhpcy5fc2NhbGVEb3duQmVoYXZpb3IsXG4gICAgICBzZWN1cml0eV9jb25maWd1cmF0aW9uOiB0aGlzLl9zZWN1cml0eUNvbmZpZ3VyYXRpb24sXG4gICAgICBzZXJ2aWNlX3JvbGU6IHRoaXMuX3NlcnZpY2VSb2xlLFxuICAgICAgc3RlcDogdGhpcy5fc3RlcCxcbiAgICAgIHN0ZXBfY29uY3VycmVuY3lfbGV2ZWw6IHRoaXMuX3N0ZXBDb25jdXJyZW5jeUxldmVsLFxuICAgICAgdGFnczogdGhpcy5fdGFncyxcbiAgICAgIHRlcm1pbmF0aW9uX3Byb3RlY3Rpb246IHRoaXMuX3Rlcm1pbmF0aW9uUHJvdGVjdGlvbixcbiAgICAgIHZpc2libGVfdG9fYWxsX3VzZXJzOiB0aGlzLl92aXNpYmxlVG9BbGxVc2VycyxcbiAgICAgIGJvb3RzdHJhcF9hY3Rpb246IHRoaXMuX2Jvb3RzdHJhcEFjdGlvbixcbiAgICAgIGNvcmVfaW5zdGFuY2VfZ3JvdXA6IHRoaXMuX2NvcmVJbnN0YW5jZUdyb3VwLFxuICAgICAgZWMyX2F0dHJpYnV0ZXM6IHRoaXMuX2VjMkF0dHJpYnV0ZXMsXG4gICAgICBpbnN0YW5jZV9ncm91cDogdGhpcy5faW5zdGFuY2VHcm91cCxcbiAgICAgIGtlcmJlcm9zX2F0dHJpYnV0ZXM6IHRoaXMuX2tlcmJlcm9zQXR0cmlidXRlcyxcbiAgICAgIG1hc3Rlcl9pbnN0YW5jZV9ncm91cDogdGhpcy5fbWFzdGVySW5zdGFuY2VHcm91cCxcbiAgICB9O1xuICB9XG59XG4iXX0=