import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface EmrInstanceGroupConfig extends TerraformMetaArguments {
    readonly autoscalingPolicy?: string;
    readonly bidPrice?: string;
    readonly clusterId: string;
    readonly configurationsJson?: string;
    readonly ebsOptimized?: boolean;
    readonly instanceCount?: number;
    readonly instanceType: string;
    readonly name?: string;
    /** ebs_config block */
    readonly ebsConfig?: EmrInstanceGroupEbsConfig[];
}
export interface EmrInstanceGroupEbsConfig {
    readonly iops?: number;
    readonly size: number;
    readonly type: string;
    readonly volumesPerInstance?: number;
}
export declare class EmrInstanceGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: EmrInstanceGroupConfig);
    private _autoscalingPolicy?;
    get autoscalingPolicy(): string | undefined;
    set autoscalingPolicy(value: string | undefined);
    private _bidPrice?;
    get bidPrice(): string | undefined;
    set bidPrice(value: string | undefined);
    private _clusterId;
    get clusterId(): string;
    set clusterId(value: string);
    private _configurationsJson?;
    get configurationsJson(): string | undefined;
    set configurationsJson(value: string | undefined);
    private _ebsOptimized?;
    get ebsOptimized(): boolean | undefined;
    set ebsOptimized(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceCount?;
    get instanceCount(): number | undefined;
    set instanceCount(value: number | undefined);
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    get runningInstanceCount(): number;
    get status(): string;
    private _ebsConfig?;
    get ebsConfig(): EmrInstanceGroupEbsConfig[] | undefined;
    set ebsConfig(value: EmrInstanceGroupEbsConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
