import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface FlowLogConfig extends TerraformMetaArguments {
    readonly eniId?: string;
    readonly iamRoleArn?: string;
    readonly logDestination?: string;
    readonly logDestinationType?: string;
    readonly logFormat?: string;
    readonly logGroupName?: string;
    readonly maxAggregationInterval?: number;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly trafficType: string;
    readonly vpcId?: string;
}
export declare class FlowLog extends TerraformResource {
    constructor(scope: Construct, id: string, config: FlowLogConfig);
    get arn(): string;
    private _eniId?;
    get eniId(): string | undefined;
    set eniId(value: string | undefined);
    private _iamRoleArn?;
    get iamRoleArn(): string | undefined;
    set iamRoleArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logDestination?;
    get logDestination(): string | undefined;
    set logDestination(value: string | undefined);
    private _logDestinationType?;
    get logDestinationType(): string | undefined;
    set logDestinationType(value: string | undefined);
    private _logFormat?;
    get logFormat(): string | undefined;
    set logFormat(value: string | undefined);
    private _logGroupName?;
    get logGroupName(): string | undefined;
    set logGroupName(value: string | undefined);
    private _maxAggregationInterval?;
    get maxAggregationInterval(): number | undefined;
    set maxAggregationInterval(value: number | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _trafficType;
    get trafficType(): string;
    set trafficType(value: string);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
