import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface FsxLustreFileSystemConfig extends TerraformMetaArguments {
    readonly exportPath?: string;
    readonly importPath?: string;
    readonly importedFileChunkSize?: number;
    readonly securityGroupIds?: string[];
    readonly storageCapacity: number;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly weeklyMaintenanceStartTime?: string;
    /** timeouts block */
    readonly timeouts?: FsxLustreFileSystemTimeouts;
}
export interface FsxLustreFileSystemTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class FsxLustreFileSystem extends TerraformResource {
    constructor(scope: Construct, id: string, config: FsxLustreFileSystemConfig);
    get arn(): string;
    get dnsName(): string;
    private _exportPath?;
    get exportPath(): string | undefined;
    set exportPath(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _importPath?;
    get importPath(): string | undefined;
    set importPath(value: string | undefined);
    private _importedFileChunkSize?;
    get importedFileChunkSize(): number | undefined;
    set importedFileChunkSize(value: number | undefined);
    get networkInterfaceIds(): string[];
    get ownerId(): string;
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _storageCapacity;
    get storageCapacity(): number;
    set storageCapacity(value: number);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _weeklyMaintenanceStartTime?;
    get weeklyMaintenanceStartTime(): string | undefined;
    set weeklyMaintenanceStartTime(value: string | undefined);
    private _timeouts?;
    get timeouts(): FsxLustreFileSystemTimeouts | undefined;
    set timeouts(value: FsxLustreFileSystemTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
