import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface FsxWindowsFileSystemConfig extends TerraformMetaArguments {
    readonly activeDirectoryId?: string;
    readonly automaticBackupRetentionDays?: number;
    readonly copyTagsToBackups?: boolean;
    readonly dailyAutomaticBackupStartTime?: string;
    readonly kmsKeyId?: string;
    readonly securityGroupIds?: string[];
    readonly skipFinalBackup?: boolean;
    readonly storageCapacity: number;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly throughputCapacity: number;
    readonly weeklyMaintenanceStartTime?: string;
    /** self_managed_active_directory block */
    readonly selfManagedActiveDirectory?: FsxWindowsFileSystemSelfManagedActiveDirectory[];
    /** timeouts block */
    readonly timeouts?: FsxWindowsFileSystemTimeouts;
}
export interface FsxWindowsFileSystemSelfManagedActiveDirectory {
    readonly dnsIps: string[];
    readonly domainName: string;
    readonly fileSystemAdministratorsGroup?: string;
    readonly organizationalUnitDistinguishedName?: string;
    readonly password: string;
    readonly username: string;
}
export interface FsxWindowsFileSystemTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class FsxWindowsFileSystem extends TerraformResource {
    constructor(scope: Construct, id: string, config: FsxWindowsFileSystemConfig);
    private _activeDirectoryId?;
    get activeDirectoryId(): string | undefined;
    set activeDirectoryId(value: string | undefined);
    get arn(): string;
    private _automaticBackupRetentionDays?;
    get automaticBackupRetentionDays(): number | undefined;
    set automaticBackupRetentionDays(value: number | undefined);
    private _copyTagsToBackups?;
    get copyTagsToBackups(): boolean | undefined;
    set copyTagsToBackups(value: boolean | undefined);
    private _dailyAutomaticBackupStartTime?;
    get dailyAutomaticBackupStartTime(): string | undefined;
    set dailyAutomaticBackupStartTime(value: string | undefined);
    get dnsName(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    get networkInterfaceIds(): string[];
    get ownerId(): string;
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _skipFinalBackup?;
    get skipFinalBackup(): boolean | undefined;
    set skipFinalBackup(value: boolean | undefined);
    private _storageCapacity;
    get storageCapacity(): number;
    set storageCapacity(value: number);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _throughputCapacity;
    get throughputCapacity(): number;
    set throughputCapacity(value: number);
    get vpcId(): string;
    private _weeklyMaintenanceStartTime?;
    get weeklyMaintenanceStartTime(): string | undefined;
    set weeklyMaintenanceStartTime(value: string | undefined);
    private _selfManagedActiveDirectory?;
    get selfManagedActiveDirectory(): FsxWindowsFileSystemSelfManagedActiveDirectory[] | undefined;
    set selfManagedActiveDirectory(value: FsxWindowsFileSystemSelfManagedActiveDirectory[] | undefined);
    private _timeouts?;
    get timeouts(): FsxWindowsFileSystemTimeouts | undefined;
    set timeouts(value: FsxWindowsFileSystemTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
